/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.parameters;

import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.InputParameter;
import dev.velix.imperat.command.parameters.NumericParameter;
import dev.velix.imperat.command.parameters.NumericRange;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.resolvers.SuggestionResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NumericParameterDecorator<S extends Source>
extends InputParameter<S>
implements NumericParameter<S> {
    private final CommandParameter<S> parameter;
    private final NumericRange range;

    NumericParameterDecorator(CommandParameter<S> parameter, NumericRange range) {
        super(parameter.name(), parameter.type(), parameter.permission(), parameter.description(), parameter.isOptional(), parameter.isFlag(), parameter.isFlag(), parameter.getDefaultValueSupplier(), NumericParameterDecorator.loadSuggestionResolver(parameter, range));
        this.parameter = parameter;
        this.range = range;
    }

    public static <S extends Source> NumericParameterDecorator<S> decorate(@NotNull CommandParameter<S> parameter, @NotNull NumericRange range) {
        return new NumericParameterDecorator<S>(parameter, range);
    }

    @Override
    public String format() {
        return this.parameter.format();
    }

    @Override
    @Nullable
    public NumericRange getRange() {
        return this.range;
    }

    private static <S extends Source> SuggestionResolver<S> loadSuggestionResolver(CommandParameter<S> parameter, NumericRange range) {
        SuggestionResolver<S> def = parameter.getSuggestionResolver();
        if (parameter.getSuggestionResolver() != null || range.getMin() == Double.MIN_VALUE && range.getMax() == Double.MAX_VALUE) {
            return def;
        }
        String suggestion = range.getMin() != Double.MIN_VALUE && range.getMax() == Double.MAX_VALUE ? "" + range.getMin() : (range.getMin() == Double.MIN_VALUE ? "" + range.getMax() : range.getMin() + "-" + range.getMax());
        return SuggestionResolver.plain(suggestion);
    }
}

