/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.parameters;

import dev.velix.imperat.annotations.base.element.ParameterElement;
import dev.velix.imperat.annotations.parameters.AnnotatedParameter;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.FlagParameter;
import dev.velix.imperat.command.parameters.InputParameter;
import dev.velix.imperat.context.Source;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class AnnotationParameterDecorator<S extends Source>
extends InputParameter<S>
implements AnnotatedParameter<S> {
    private final CommandParameter<S> parameter;
    private final ParameterElement element;

    AnnotationParameterDecorator(CommandParameter<S> parameter, ParameterElement element) {
        super(parameter.name(), parameter.type(), parameter.permission(), parameter.description(), parameter.isOptional(), parameter.isFlag(), parameter.isGreedy(), parameter.getDefaultValueSupplier(), parameter.getSuggestionResolver());
        this.parameter = parameter;
        this.element = element;
    }

    public static <S extends Source> AnnotationParameterDecorator<S> decorate(CommandParameter<S> parameter, ParameterElement element) {
        return new AnnotationParameterDecorator<S>(parameter, element);
    }

    @Override
    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.element.getAnnotation(clazz);
    }

    @Override
    public @Unmodifiable Collection<? extends Annotation> getAnnotations() {
        return List.of(this.element.getAnnotations());
    }

    @Override
    public String format() {
        return this.parameter.format();
    }

    @Override
    public FlagParameter<S> asFlagParameter() {
        return this.parameter.asFlagParameter();
    }
}

