/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base.element.selector;

import dev.velix.imperat.annotations.base.element.ClassElement;
import dev.velix.imperat.annotations.base.element.MethodElement;
import dev.velix.imperat.annotations.base.element.ParameterElement;
import dev.velix.imperat.annotations.base.element.selector.Rule;
import dev.velix.imperat.context.Source;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public interface MethodRules {
    public static final Rule<MethodElement> IS_PUBLIC;
    public static final Rule<MethodElement> RETURNS_VOID;
    public static final Rule<MethodElement> HAS_KNOWN_SENDER;
    public static final Rule<MethodElement> HAS_LEAST_ONLY_ONE_MAIN_ANNOTATION;

    private static IllegalStateException methodError(MethodElement element, String msg) {
        ClassElement parent = (ClassElement)element.getParent();
        if (!1.$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        return new IllegalStateException(String.format("Method '%s' In class '%s' " + msg, ((Method)element.getElement()).getName(), ((Class)parent.getElement()).getName()));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        IS_PUBLIC = Rule.buildForMethod().condition((imperat, registry, method) -> Modifier.isPublic(method.getModifiers())).failure((registry, method) -> {
            throw MethodRules.methodError(method, "is not public");
        }).build();
        RETURNS_VOID = Rule.buildForMethod().condition((imperat, registry, method) -> method.getReturnType() == Void.TYPE).failure((registry, method) -> {
            throw MethodRules.methodError(method, "should return void");
        }).build();
        HAS_KNOWN_SENDER = Rule.buildForMethod().condition((imperat, registry, method) -> {
            ParameterElement parameterElement = method.getParameterAt(0);
            if (parameterElement == null) {
                return false;
            }
            return imperat.canBeSender(parameterElement.getType()) || imperat.config().hasSourceResolver(parameterElement.getType());
        }).failure((registry, method) -> {
            ParameterElement parameterElement = method.getParameterAt(0);
            String msg = parameterElement == null ? "Method '" + method.getName() + "' has no parameters" : "First parameter of valueType '" + parameterElement.getType().getTypeName() + "' is not a sub-valueType of `" + Source.class.getName() + "'";
            throw MethodRules.methodError(method, msg);
        }).build();
        HAS_LEAST_ONLY_ONE_MAIN_ANNOTATION = Rule.buildForMethod().condition((imperat, registry, element) -> {
            long count = Arrays.stream(element.getDeclaredAnnotations()).filter(annotation -> registry.isEntryPointAnnotation(annotation.annotationType())).count();
            return count == 1L;
        }).failure((registry, element) -> {
            StringBuilder builder = new StringBuilder();
            Annotation[] declaredAnnotations = element.getDeclaredAnnotations();
            int declaredAnnotationsLength = declaredAnnotations.length;
            for (int i = 0; i < declaredAnnotationsLength; ++i) {
                Annotation annotation = declaredAnnotations[i];
                if (registry.isEntryPointAnnotation(annotation.annotationType())) {
                    builder.append("@").append(annotation.annotationType().getSimpleName());
                }
                if (i == declaredAnnotationsLength - 1) continue;
                builder.append(", ");
            }
            throw MethodRules.methodError(element, "has more than one main annotations such as: `" + String.valueOf(builder) + "`");
        }).build();
    }
}

