/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base.element;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.annotations.Async;
import dev.velix.imperat.annotations.Command;
import dev.velix.imperat.annotations.Cooldown;
import dev.velix.imperat.annotations.Default;
import dev.velix.imperat.annotations.DefaultProvider;
import dev.velix.imperat.annotations.Description;
import dev.velix.imperat.annotations.Flag;
import dev.velix.imperat.annotations.Greedy;
import dev.velix.imperat.annotations.Named;
import dev.velix.imperat.annotations.Optional;
import dev.velix.imperat.annotations.Permission;
import dev.velix.imperat.annotations.PostProcessor;
import dev.velix.imperat.annotations.PreProcessor;
import dev.velix.imperat.annotations.Range;
import dev.velix.imperat.annotations.SubCommand;
import dev.velix.imperat.annotations.Suggest;
import dev.velix.imperat.annotations.SuggestionProvider;
import dev.velix.imperat.annotations.Switch;
import dev.velix.imperat.annotations.Usage;
import dev.velix.imperat.annotations.Values;
import dev.velix.imperat.annotations.base.AnnotationHelper;
import dev.velix.imperat.annotations.base.AnnotationParser;
import dev.velix.imperat.annotations.base.MethodCommandExecutor;
import dev.velix.imperat.annotations.base.element.ClassElement;
import dev.velix.imperat.annotations.base.element.CommandClassVisitor;
import dev.velix.imperat.annotations.base.element.MethodElement;
import dev.velix.imperat.annotations.base.element.ParameterElement;
import dev.velix.imperat.annotations.base.element.ParseElement;
import dev.velix.imperat.annotations.base.element.selector.ElementSelector;
import dev.velix.imperat.annotations.parameters.AnnotationParameterDecorator;
import dev.velix.imperat.annotations.parameters.NumericParameterDecorator;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandCoordinator;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.ConstrainedParameterTypeDecorator;
import dev.velix.imperat.command.parameters.InputParameter;
import dev.velix.imperat.command.parameters.NumericRange;
import dev.velix.imperat.command.parameters.StrictParameterList;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.command.processors.CommandPostProcessor;
import dev.velix.imperat.command.processors.CommandPreProcessor;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.supplier.OptionalValueSupplier;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.TypeWrap;
import dev.velix.imperat.util.reflection.Reflections;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class SimpleCommandClassVisitor<S extends Source>
extends CommandClassVisitor<S> {
    private final ImperatConfig<S> config;
    private static final String VALUES_SEPARATION_CHAR = "\\|";

    SimpleCommandClassVisitor(Imperat<S> imperat, AnnotationParser<S> parser, ElementSelector<MethodElement> methodSelector) {
        super(imperat, parser, methodSelector);
        this.config = imperat.config();
    }

    @Override
    public Set<dev.velix.imperat.command.Command<S>> visitCommandClass(@NotNull ClassElement clazz) {
        HashSet<dev.velix.imperat.command.Command<S>> commands = new HashSet<dev.velix.imperat.command.Command<S>>();
        Annotation commandAnnotation = this.getCommandAnnotation(clazz);
        if (clazz.isRootClass() && commandAnnotation != null && clazz.isAnnotationPresent(SubCommand.class)) {
            throw new IllegalStateException("Root command class cannot be a @SubCommand");
        }
        if (commandAnnotation != null) {
            dev.velix.imperat.command.Command<S> cmd = this.loadCommand(null, clazz, commandAnnotation);
            if (cmd != null) {
                this.loadCommandMethods(clazz);
                commands.add(cmd);
            }
        } else {
            for (ParseElement<?> element : clazz.getChildren()) {
                dev.velix.imperat.command.Command<S> cmd;
                if (!element.isAnnotationPresent(Command.class) || (cmd = this.loadCommand(null, element, Objects.requireNonNull(element.getAnnotation(Command.class)))) == null) continue;
                this.imperat.registerCommand(cmd);
            }
        }
        return commands;
    }

    private Annotation getCommandAnnotation(ClassElement clazz) {
        if (clazz.isAnnotationPresent(Command.class)) {
            return clazz.getAnnotation(Command.class);
        }
        if (clazz.isAnnotationPresent(SubCommand.class)) {
            return clazz.getAnnotation(SubCommand.class);
        }
        return null;
    }

    private void loadCommandMethods(ClassElement clazz) {
        for (ParseElement<?> element : clazz.getChildren()) {
            MethodElement method;
            if (!(element instanceof MethodElement) || !(method = (MethodElement)element).isAnnotationPresent(Command.class)) continue;
            Command cmdAnn = method.getAnnotation(Command.class);
            assert (cmdAnn != null);
            this.imperat.registerCommand(this.loadCommand(null, method, cmdAnn));
        }
    }

    private dev.velix.imperat.command.Command<S> loadCmdInstance(Annotation cmdAnnotation, ParseElement<?> element) {
        PreProcessor preProcessor = element.getAnnotation(PreProcessor.class);
        PostProcessor postProcessor = element.getAnnotation(PostProcessor.class);
        Permission permission = element.getAnnotation(Permission.class);
        Description description = element.getAnnotation(Description.class);
        if (cmdAnnotation instanceof Command) {
            Command cmdAnn = (Command)cmdAnnotation;
            String[] values = this.config.replacePlaceholders(cmdAnn.value());
            List<String> aliases = List.of(values).subList(1, values.length);
            boolean ignoreAC = cmdAnn.skipSuggestionsChecks();
            Command.Builder<S> builder = dev.velix.imperat.command.Command.create(values[0]).ignoreACPermissions(ignoreAC).aliases(aliases);
            if (permission != null) {
                builder.permission(this.config.replacePlaceholders(permission.value()));
            }
            if (description != null) {
                builder.description(this.config.replacePlaceholders(description.value()));
            }
            if (preProcessor != null) {
                builder.preProcessor(this.loadPreProcessorInstance(preProcessor.value()));
            }
            if (postProcessor != null) {
                builder.postProcessor(this.loadPostProcessorInstance(postProcessor.value()));
            }
            return builder.build();
        }
        if (cmdAnnotation instanceof SubCommand) {
            SubCommand subCommand = (SubCommand)cmdAnnotation;
            String[] values = this.config.replacePlaceholders(subCommand.value());
            assert (values != null);
            List<String> aliases = List.of(values).subList(1, values.length);
            boolean ignoreAC = subCommand.skipSuggestionsChecks();
            Command.Builder<S> builder = dev.velix.imperat.command.Command.create(values[0]).ignoreACPermissions(ignoreAC).aliases(aliases);
            if (permission != null) {
                builder.permission(this.config.replacePlaceholders(permission.value()));
            }
            if (description != null) {
                builder.description(this.config.replacePlaceholders(description.value()));
            }
            if (preProcessor != null) {
                builder.preProcessor(this.loadPreProcessorInstance(preProcessor.value()));
            }
            if (postProcessor != null) {
                builder.postProcessor(this.loadPostProcessorInstance(postProcessor.value()));
            }
            return builder.build();
        }
        return null;
    }

    private dev.velix.imperat.command.Command<S> loadCommand(@Nullable dev.velix.imperat.command.Command<S> parentCmd, ParseElement<?> parseElement, @NotNull Annotation annotation) {
        dev.velix.imperat.command.Command<S> cmd = this.loadCmdInstance(annotation, parseElement);
        if (parentCmd != null && cmd != null) {
            cmd.parent(parentCmd);
        }
        if (parseElement instanceof MethodElement) {
            MethodElement method = (MethodElement)parseElement;
            if (cmd != null) {
                if (!this.methodSelector.canBeSelected(this.imperat, this.parser, method, true)) {
                    ImperatDebugger.debugForTesting("Method '%s' has failed verification", method.getName());
                    return cmd;
                }
                CommandUsage<S> usage = this.loadUsage(parentCmd, cmd, method);
                if (usage != null) {
                    cmd.addUsage(usage);
                }
                return cmd;
            }
        }
        if (parseElement instanceof ClassElement) {
            ClassElement commandClass = (ClassElement)parseElement;
            for (ParseElement<?> element : commandClass.getChildren()) {
                if (element instanceof MethodElement) {
                    MethodElement method = (MethodElement)element;
                    if (cmd == null) {
                        throw new IllegalStateException("Method  '" + ((Method)method.getElement()).getName() + "' Cannot be treated as usage/subcommand, it doesn't have a parent ");
                    }
                    if (!this.methodSelector.canBeSelected(this.imperat, this.parser, method, true)) {
                        return cmd;
                    }
                    if (method.isAnnotationPresent(Usage.class)) {
                        CommandUsage<S> usage = this.loadUsage(parentCmd, cmd, method);
                        if (usage == null) continue;
                        cmd.addUsage(usage);
                        continue;
                    }
                    if (!method.isAnnotationPresent(SubCommand.class)) continue;
                    SubCommand subAnn = method.getAnnotation(SubCommand.class);
                    assert (subAnn != null);
                    dev.velix.imperat.command.Command<S> subCmd = this.loadCommand(cmd, method, subAnn);
                    assert (subCmd != null);
                    cmd.addSubCommand(subCmd, subAnn.attachDirectly());
                    continue;
                }
                if (!(element instanceof ClassElement)) continue;
                ClassElement innerClass = (ClassElement)element;
                if (innerClass.isAnnotationPresent(Command.class)) {
                    Command innerCmdAnn = innerClass.getAnnotation(Command.class);
                    assert (innerCmdAnn != null);
                    this.imperat.registerCommand(this.loadCommand(null, innerClass, innerCmdAnn));
                    return null;
                }
                if (!innerClass.isAnnotationPresent(SubCommand.class)) continue;
                if (cmd == null) {
                    throw new IllegalStateException("Inner class '" + ((Class)innerClass.getElement()).getSimpleName() + "' Cannot be  treated as subcommand, it doesn't have a parent ");
                }
                SubCommand subCommandAnn = innerClass.getAnnotation(SubCommand.class);
                assert (subCommandAnn != null);
                cmd.addSubCommand(this.loadCommand(cmd, innerClass, subCommandAnn), subCommandAnn.attachDirectly());
            }
        }
        return cmd;
    }

    private CommandPreProcessor<S> loadPreProcessorInstance(Class<? extends CommandPreProcessor<?>> clazz) {
        Constructor<?> constructor = Reflections.getConstructor(clazz, new Class[0]);
        if (constructor == null) {
            throw new UnsupportedOperationException("Couldn't find constructor in class `" + clazz.getSimpleName() + "`");
        }
        try {
            return (CommandPreProcessor)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private CommandPostProcessor<S> loadPostProcessorInstance(Class<? extends CommandPostProcessor<?>> clazz) {
        Constructor<?> constructor = Reflections.getConstructor(clazz, new Class[0]);
        if (constructor == null) {
            throw new UnsupportedOperationException("Couldn't find constructor in class `" + clazz.getSimpleName() + "`");
        }
        try {
            return (CommandPostProcessor)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private CommandUsage<S> loadUsage(@Nullable dev.velix.imperat.command.Command<S> parentCmd, @NotNull dev.velix.imperat.command.Command<S> loadedCmd, MethodElement method) {
        boolean isAttachedDirectly = SimpleCommandClassVisitor.isIsAttachedDirectlySubCmd(method);
        int inputCount = method.getInputCount();
        if (parentCmd != null) {
            int parentalParams = 0;
            if (!isAttachedDirectly) {
                ImperatDebugger.debugForTesting("Going in deep for method '%s'", method.getName());
                for (dev.velix.imperat.command.Command<S> parent = parentCmd; parent != null; parent = parent.parent()) {
                    parentalParams += parent.mainUsage().size();
                }
            }
            inputCount = Math.abs(method.getInputCount() - parentalParams);
        }
        ImperatDebugger.debugForTesting("The method-usage '%s', has '%s' calculated input count", method.getName(), inputCount);
        if (inputCount == 0) {
            if (parentCmd != null && !isAttachedDirectly) {
                assert (method.getParent() != null);
                MethodUsageData<S> usageData = this.loadParameters(method, parentCmd);
                loadedCmd.setDefaultUsageExecution(MethodCommandExecutor.of(this.imperat, method, usageData.inheritedTotalParameters()));
            } else {
                loadedCmd.setDefaultUsageExecution(MethodCommandExecutor.of(this.imperat, method, Collections.emptyList()));
            }
            Cooldown cooldown = method.getAnnotation(Cooldown.class);
            Async async = method.getAnnotation(Async.class);
            if (cooldown != null) {
                String cooldownPerm = cooldown.permission();
                loadedCmd.getDefaultUsage().setCooldown(cooldown.value(), cooldown.unit(), cooldownPerm.isEmpty() ? null : cooldownPerm);
            }
            if (async != null) {
                loadedCmd.getDefaultUsage().setCoordinator(CommandCoordinator.async());
            }
            return null;
        }
        MethodUsageData<S> usageData = this.loadParameters(method, parentCmd);
        MethodCommandExecutor<S> execution = MethodCommandExecutor.of(this.imperat, method, usageData.inheritedTotalParameters());
        Description description = method.getAnnotation(Description.class);
        Permission permission = method.getAnnotation(Permission.class);
        Cooldown cooldown = method.getAnnotation(Cooldown.class);
        Async async = method.getAnnotation(Async.class);
        CommandUsage.Builder builder = CommandUsage.builder().parameters(usageData.personalParameters()).execute(execution);
        if (description != null) {
            builder.description(this.config.replacePlaceholders(description.value()));
        }
        if (permission != null) {
            builder.permission(this.config.replacePlaceholders(permission.value()));
        }
        if (cooldown != null) {
            ImperatDebugger.debug("Method '%s' has cooldown", method.getName());
            String cooldownPerm = cooldown.permission();
            builder.cooldown(cooldown.value(), cooldown.unit(), cooldownPerm.isEmpty() ? null : cooldownPerm);
        }
        if (async != null) {
            builder.coordinator(CommandCoordinator.async());
        }
        return builder.registerFlags(usageData.freeFlags).build(loadedCmd, method.isHelp());
    }

    private MethodUsageData<S> loadParameters(@NotNull MethodElement method, @Nullable dev.velix.imperat.command.Command<S> parentCmd) {
        ParameterElement parameterElement;
        ImperatDebugger.debugForTesting("Loading for method '%s'", method.getName());
        LinkedList toLoad = new LinkedList();
        StrictParameterList mainUsageParameters = new StrictParameterList();
        boolean isAttachedDirectlySubCmd = SimpleCommandClassVisitor.isIsAttachedDirectlySubCmd(method);
        if (!isAttachedDirectlySubCmd) {
            LinkedList<dev.velix.imperat.command.Command<S>> parenteralSequence = SimpleCommandClassVisitor.getParenteralSequence(parentCmd);
            for (dev.velix.imperat.command.Command command : parenteralSequence) {
                command.mainUsage().getParameters().forEach(param -> {
                    if (!param.isFlag() || !param.asFlagParameter().flagData().isFree()) {
                        mainUsageParameters.add(param);
                    }
                });
            }
        }
        StringBuilder inheritedParamsFormatted = SimpleCommandClassVisitor.getMainUsageParametersCollected(mainUsageParameters);
        ImperatDebugger.debugForTesting("Main usage params collected '%s'", inheritedParamsFormatted.toString());
        LinkedList total = new LinkedList(mainUsageParameters);
        LinkedList<ParameterElement> linkedList = new LinkedList<ParameterElement>(method.getParameters());
        ImperatDebugger.debugForTesting("Method parameters collected '%s'", this.getMethodParamsCollected(linkedList));
        HashSet freeFlags = new HashSet();
        ParameterElement senderParam = null;
        if (!isAttachedDirectlySubCmd && linkedList.size() - 1 == 0 && !mainUsageParameters.isEmpty() && parentCmd != null) {
            assert (method.getParent() != null);
            throw new IllegalStateException("You have inherited parameters ('%s') that are not declared in the method '%s' in class '%s'".formatted(inheritedParamsFormatted, method.getName(), method.getParent().getName()));
        }
        while (!linkedList.isEmpty() && (parameterElement = linkedList.peek()) != null) {
            Type type = ((Parameter)parameterElement.getElement()).getParameterizedType();
            if (senderParam == null && this.isSenderParameter(parameterElement) || this.config.hasContextResolver(type)) {
                senderParam = linkedList.remove();
                continue;
            }
            CommandParameter<S> commandParameter = this.loadParameter(parameterElement);
            if (commandParameter.isFlag() && commandParameter.asFlagParameter().flagData().isFree()) {
                freeFlags.add(commandParameter.asFlagParameter().flagData());
                linkedList.remove();
                continue;
            }
            CommandParameter mainParameter = (CommandParameter)mainUsageParameters.peek();
            if (mainParameter != null) {
                ImperatDebugger.debugForTesting("Comparing main-usage parameter '%s' with loaded parameter '%s'", mainParameter.format(), commandParameter.format());
            }
            if (mainParameter == null) {
                ImperatDebugger.debugForTesting("Adding command parameter '%s' that has no corresponding main parameter", commandParameter.format());
                toLoad.add(commandParameter);
                total.add(commandParameter);
                linkedList.remove();
                continue;
            }
            if (mainParameter.similarTo(commandParameter)) {
                ImperatDebugger.debugForTesting("Main parameter '%s' is exactly similar to loaded parameter '%s'", mainParameter.format(), commandParameter.format());
                ParameterElement methodParam = linkedList.remove();
                ImperatDebugger.debugForTesting("Removing '%s' from method params", methodParam.getName());
                CommandParameter mainUsageParam = (CommandParameter)mainUsageParameters.remove();
                ImperatDebugger.debugForTesting("Removing '%s' from main usage params", mainUsageParam.format());
                continue;
            }
            toLoad.add(commandParameter);
            total.add(commandParameter);
            mainUsageParameters.remove();
            linkedList.remove();
        }
        return new MethodUsageData(toLoad, total, freeFlags);
    }

    private static boolean isIsAttachedDirectlySubCmd(@NotNull MethodElement method) {
        boolean isAttachedDirectlySubCmd = false;
        if (method.isAnnotationPresent(SubCommand.class)) {
            isAttachedDirectlySubCmd = Objects.requireNonNull(method.getAnnotation(SubCommand.class)).attachDirectly();
        } else if (method.isAnnotationPresent(Usage.class)) {
            assert (method.getParent() != null);
            SubCommand ann = method.getParent().getAnnotation(SubCommand.class);
            if (ann != null) {
                isAttachedDirectlySubCmd = ann.attachDirectly();
            }
        }
        return isAttachedDirectlySubCmd;
    }

    private boolean isSenderParameter(ParameterElement parameter) {
        Type type = ((Parameter)parameter.getElement()).getParameterizedType();
        return this.imperat.canBeSender(type) || this.config.hasSourceResolver(type);
    }

    private String getMethodParamsCollected(LinkedList<ParameterElement> methodParameters) {
        StringBuilder builder = new StringBuilder();
        for (ParameterElement pe : methodParameters) {
            builder.append(pe.getName()).append(" ");
        }
        return builder.toString();
    }

    @NotNull
    private static <S extends Source> StringBuilder getMainUsageParametersCollected(StrictParameterList<S> mainUsageParameters) {
        StringBuilder builder = new StringBuilder();
        for (CommandParameter commandParameter : mainUsageParameters) {
            builder.append(commandParameter.format()).append(" ");
        }
        return builder;
    }

    @NotNull
    private static <S extends Source> LinkedList<dev.velix.imperat.command.Command<S>> getParenteralSequence(@Nullable dev.velix.imperat.command.Command<S> parentCmd) {
        LinkedList<dev.velix.imperat.command.Command<S>> parenteralSequence = new LinkedList<dev.velix.imperat.command.Command<S>>();
        for (dev.velix.imperat.command.Command<S> currentParent = parentCmd; currentParent != null; currentParent = currentParent.parent()) {
            parenteralSequence.addFirst(currentParent);
        }
        return parenteralSequence;
    }

    private <T> CommandParameter<S> loadParameter(@NotNull ParseElement<?> paramElement) {
        InputParameter param;
        boolean greedy;
        ParameterElement element = (ParameterElement)paramElement;
        Parameter parameter = (Parameter)element.getElement();
        Named named = parameter.getAnnotation(Named.class);
        Flag flag = parameter.getAnnotation(Flag.class);
        Switch switchAnnotation = parameter.getAnnotation(Switch.class);
        if (flag != null && switchAnnotation != null) {
            throw new IllegalStateException("both @Flag and @Switch at the same time !");
        }
        TypeWrap<?> parameterTypeWrap = TypeWrap.of(parameter.getParameterizedType());
        ParameterType<S, ?> type = this.config.getParameterType(parameterTypeWrap.getType());
        if (type == null) {
            throw new IllegalArgumentException("Unknown type detected '" + parameterTypeWrap.getType().getTypeName() + "'");
        }
        String name = AnnotationHelper.getParamName(this.config, parameter, named, flag, switchAnnotation);
        boolean optional = flag != null || switchAnnotation != null || element.isAnnotationPresent(Optional.class) || element.isAnnotationPresent(Default.class) || element.isAnnotationPresent(DefaultProvider.class);
        Suggest suggestAnnotation = element.getAnnotation(Suggest.class);
        SuggestionProvider suggestionProvider = element.getAnnotation(SuggestionProvider.class);
        SuggestionResolver suggestionResolver = null;
        if (suggestAnnotation != null) {
            suggestionResolver = SuggestionResolver.plain(this.config.replacePlaceholders(suggestAnnotation.value()));
        } else if (suggestionProvider != null) {
            String suggestionResolverName = this.config.replacePlaceholders(suggestionProvider.value().toLowerCase());
            SuggestionResolver namedResolver = this.config.getNamedSuggestionResolver(suggestionResolverName);
            if (namedResolver != null) {
                suggestionResolver = namedResolver;
            } else {
                throw new IllegalStateException("Unregistered named suggestion resolver : " + suggestionResolverName);
            }
        }
        boolean bl = greedy = parameter.getAnnotation(Greedy.class) != null;
        if (greedy && parameter.getType() != String.class) {
            throw new IllegalArgumentException("Argument '" + parameter.getName() + "' is greedy while having a non-greedy valueType '" + parameter.getType().getName() + "'");
        }
        dev.velix.imperat.command.Description desc = dev.velix.imperat.command.Description.EMPTY;
        if (element.isAnnotationPresent(Description.class)) {
            Description descAnn = element.getAnnotation(Description.class);
            assert (descAnn != null);
            desc = dev.velix.imperat.command.Description.of(this.config.replacePlaceholders(descAnn.value()));
        }
        String permission = null;
        if (element.isAnnotationPresent(Permission.class)) {
            Permission permAnn = element.getAnnotation(Permission.class);
            assert (permAnn != null);
            permission = this.config.replacePlaceholders(permAnn.value());
        }
        OptionalValueSupplier<?> optionalValueSupplier = OptionalValueSupplier.empty(parameterTypeWrap);
        if (optional) {
            Default defaultAnnotation = parameter.getAnnotation(Default.class);
            DefaultProvider provider = parameter.getAnnotation(DefaultProvider.class);
            try {
                optionalValueSupplier = AnnotationHelper.deduceOptionalValueSupplier(this.imperat, parameter, defaultAnnotation, provider, optionalValueSupplier);
            }
            catch (ImperatException e) {
                ImperatDebugger.error(AnnotationHelper.class, "deduceOptionalValueSupplier", e);
            }
        }
        if (flag != null) {
            String[] flagAliases = flag.value();
            if (suggestAnnotation != null) {
                suggestionResolver = SuggestionResolver.plain(this.config.replacePlaceholders(suggestAnnotation.value()));
            }
            return AnnotationParameterDecorator.decorate(CommandParameter.flag(name, type).setFree(flag.free()).suggestForInputValue(suggestionResolver).aliases(this.getAllExceptFirst(flagAliases)).flagDefaultInputValue(optionalValueSupplier).description(desc).permission(permission).build(), element);
        }
        if (switchAnnotation != null) {
            String[] switchAliases = switchAnnotation.value();
            return AnnotationParameterDecorator.decorate(CommandParameter.flagSwitch(name).setFree(switchAnnotation.free()).aliases(this.getAllExceptFirst(switchAliases)).description(desc).permission(permission).build(), element);
        }
        if (element.isAnnotationPresent(Values.class)) {
            Values valuesAnnotation = element.getAnnotation(Values.class);
            assert (valuesAnnotation != null);
            Set values = Arrays.stream(valuesAnnotation.value()).distinct().map(this.config::replacePlaceholders).flatMap(replaced -> {
                if (replaced.contains("|")) {
                    return Arrays.stream(replaced.split(VALUES_SEPARATION_CHAR));
                }
                return Stream.of(replaced);
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            type = ConstrainedParameterTypeDecorator.of(type, values, valuesAnnotation.caseSensitive());
        }
        if (TypeUtility.isNumericType(TypeWrap.of((param = AnnotationParameterDecorator.decorate(CommandParameter.of(name, type, permission, desc, optional, greedy, optionalValueSupplier, suggestionResolver), element)).valueType())) && element.isAnnotationPresent(Range.class)) {
            Range range = element.getAnnotation(Range.class);
            assert (range != null);
            param = NumericParameterDecorator.decorate(param, NumericRange.of(range.min(), range.max()));
        }
        return param;
    }

    private List<String> getAllExceptFirst(String[] array) {
        ArrayList<String> flagAliases = new ArrayList<String>(array.length - 1);
        flagAliases.addAll(List.of(array).subList(1, array.length));
        return flagAliases;
    }

    private record MethodUsageData<S extends Source>(List<CommandParameter<S>> personalParameters, List<CommandParameter<S>> inheritedTotalParameters, Set<FlagData<S>> freeFlags) {
    }
}

