/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base.element;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.annotations.base.AnnotationHelper;
import dev.velix.imperat.annotations.base.AnnotationParser;
import dev.velix.imperat.annotations.base.element.ClassElement;
import dev.velix.imperat.annotations.base.element.ParameterElement;
import dev.velix.imperat.annotations.base.element.ParseElement;
import dev.velix.imperat.context.Source;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodElement
extends ParseElement<Method> {
    private final List<ParameterElement> parameters = new ArrayList<ParameterElement>();
    private int inputCount = 0;
    private boolean help = false;

    public <S extends Source> MethodElement(@NotNull Imperat<S> imperat, @NotNull AnnotationParser<S> registry, @Nullable ClassElement owningElement, @NotNull Method element) {
        super(registry, owningElement, element);
        Parameter[] params = element.getParameters();
        for (int i = 1; i < params.length; ++i) {
            Parameter parameter = params[i];
            if (AnnotationHelper.isHelpParameter(parameter)) {
                this.help = true;
                continue;
            }
            if (imperat.config().hasContextResolver(parameter.getType())) continue;
            ++this.inputCount;
        }
        for (Parameter parameter : params) {
            this.parameters.add(new ParameterElement(registry, owningElement, this, parameter));
        }
    }

    @Nullable
    public ParameterElement getParameterAt(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.parameters.get(index);
    }

    public int size() {
        return this.parameters.size();
    }

    public Type getReturnType() {
        return ((Method)this.getElement()).getReturnType();
    }

    public int getModifiers() {
        return ((Method)this.getElement()).getModifiers();
    }

    @Override
    public String getName() {
        return ((Method)this.getElement()).getName();
    }

    public List<ParameterElement> getParameters() {
        return this.parameters;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean isHelp() {
        return this.help;
    }
}

