/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base.element;

import dev.velix.imperat.annotations.Dependency;
import dev.velix.imperat.annotations.base.AnnotationParser;
import dev.velix.imperat.annotations.base.element.CommandClassVisitor;
import dev.velix.imperat.annotations.base.element.ParseElement;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.util.reflection.Reflections;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassElement
extends ParseElement<Class<?>> {
    private final Set<ParseElement<?>> children = new LinkedHashSet();
    private final Object instance = this.newInstance(new Object[0]);

    public <S extends Source> ClassElement(@NotNull AnnotationParser<S> parser, @Nullable ClassElement parent, @NotNull Class<?> element) {
        super(parser, parent, element);
        this.injectDependencies();
    }

    private void injectDependencies() {
        IllegalAccessException exception = null;
        for (Field field : ((Class)this.element).getDeclaredFields()) {
            if (!field.isAnnotationPresent(Dependency.class)) continue;
            if (Modifier.isFinal(field.getModifiers())) {
                throw new IllegalArgumentException("Field '" + field.getName() + "' cannot be declared final while being annotated with `@Dependency`");
            }
            field.setAccessible(true);
            try {
                Object supplied = this.parser.getImperat().config().resolveDependency(field.getType());
                field.set(this.instance, supplied);
            }
            catch (IllegalAccessException e) {
                exception = e;
                break;
            }
        }
        if (exception != null) {
            throw new RuntimeException(exception);
        }
    }

    private Object newInstance(Object ... constructorArgs) {
        Class[] types = new Class[constructorArgs.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = constructorArgs[i].getClass();
        }
        try {
            Constructor<?> cons = Reflections.getConstructor((Class)this.element, types);
            if (cons == null) {
                throw new IllegalCallerException("Class " + ((Class)this.element).getSimpleName() + " doesn't have a constructor matching the arguments");
            }
            return cons.newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getObjectInstance() {
        return this.instance;
    }

    public <S extends Source> Set<Command<S>> accept(CommandClassVisitor<S> visitor) {
        try {
            return visitor.visitCommandClass(this);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return Collections.emptySet();
        }
    }

    @Nullable
    public ParseElement<?> getChildElement(Predicate<ParseElement<?>> predicate) {
        for (ParseElement<?> element : this.getChildren()) {
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    public void addChild(ParseElement<?> element) {
        this.children.add(element);
    }

    public boolean isRootClass() {
        return this.getParent() == null;
    }

    @Override
    public String getName() {
        return ((Class)this.getElement()).getName();
    }

    public String getSimpleName() {
        return ((Class)this.getElement()).getSimpleName();
    }

    public Set<ParseElement<?>> getChildren() {
        return this.children;
    }
}

