/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.annotations.base.AnnotationHelper;
import dev.velix.imperat.annotations.base.element.ClassElement;
import dev.velix.imperat.annotations.base.element.MethodElement;
import dev.velix.imperat.command.CommandExecution;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.asm.DefaultMethodCallerFactory;
import dev.velix.imperat.util.asm.MethodCaller;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MethodCommandExecutor<S extends Source>
implements CommandExecution<S> {
    private final Imperat<S> dispatcher;
    private final ClassElement methodOwner;
    private final MethodElement method;
    private final MethodCaller.BoundMethodCaller boundMethodCaller;
    private final List<CommandParameter<S>> fullParameters;

    private MethodCommandExecutor(Imperat<S> dispatcher, MethodElement method, List<CommandParameter<S>> fullParameters) {
        try {
            this.dispatcher = dispatcher;
            this.method = method;
            this.methodOwner = (ClassElement)method.getParent();
            assert (this.methodOwner != null);
            this.boundMethodCaller = DefaultMethodCallerFactory.INSTANCE.createFor((Method)method.getElement()).bindTo(this.methodOwner.getObjectInstance());
            this.fullParameters = fullParameters;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <S extends Source> MethodCommandExecutor<S> of(Imperat<S> imperat, MethodElement method, List<CommandParameter<S>> fullParameters) {
        return new MethodCommandExecutor<S>(imperat, method, fullParameters);
    }

    @Override
    public void execute(S source, ExecutionContext<S> context) throws ImperatException {
        ImperatDebugger.debugForTesting("Debugging params:-", new Object[0]);
        for (CommandParameter<S> param : this.fullParameters) {
            ImperatDebugger.debugForTesting("-%s", param.format());
        }
        ImperatDebugger.debugForTesting("SIZE=%s", this.fullParameters.size());
        Object[] instances = AnnotationHelper.loadParameterInstances(this.dispatcher, this.fullParameters, source, context, this.method);
        for (int i = 0; i < instances.length; ++i) {
            Object instance = instances[i];
            ImperatDebugger.debugForTesting("Object #%s = '%s', type='%s'", i, instance, instance != null ? instances[i].getClass().getName() : "N/A");
        }
        try {
            this.boundMethodCaller.call(instances);
        }
        catch (Exception ex) {
            ImperatDebugger.error((Class)this.methodOwner.getElement(), ((Method)this.method.getElement()).getName(), ex);
        }
    }
}

