/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.annotations.base.AnnotationParser;
import dev.velix.imperat.annotations.base.AnnotationReader;
import dev.velix.imperat.annotations.base.AnnotationRegistry;
import dev.velix.imperat.annotations.base.AnnotationReplacer;
import dev.velix.imperat.annotations.base.element.CommandClassVisitor;
import dev.velix.imperat.annotations.base.element.MethodElement;
import dev.velix.imperat.annotations.base.element.selector.ElementSelector;
import dev.velix.imperat.annotations.base.element.selector.MethodRules;
import dev.velix.imperat.context.Source;
import java.lang.annotation.Annotation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class AnnotationParserImpl<S extends Source>
extends AnnotationParser<S> {
    private final AnnotationRegistry annotationRegistry = new AnnotationRegistry();
    private final ElementSelector<MethodElement> methodSelector = ElementSelector.create();
    private final CommandClassVisitor<S> visitor;

    AnnotationParserImpl(Imperat<S> dispatcher) {
        super(dispatcher);
        this.methodSelector.addRule(MethodRules.IS_PUBLIC.and(MethodRules.RETURNS_VOID));
        this.visitor = CommandClassVisitor.newSimpleVisitor(dispatcher, this);
    }

    @Override
    public <T> void parseCommandClass(T instance) {
        AnnotationReader<S> reader = AnnotationReader.read(this.imperat, this.methodSelector, this, instance);
        reader.accept(this.visitor);
    }

    @Override
    @SafeVarargs
    public final void registerAnnotations(Class<? extends Annotation> ... type) {
        this.annotationRegistry.registerAnnotationTypes(type);
    }

    @Override
    public <A extends Annotation> void registerAnnotationReplacer(Class<A> type, AnnotationReplacer<A> replacer) {
        this.annotationRegistry.registerAnnotationReplacer(type, replacer);
    }

    @Override
    public boolean isKnownAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotationRegistry.isRegisteredAnnotation(annotationType);
    }

    @Override
    public boolean hasAnnotationReplacerFor(Class<? extends Annotation> type) {
        return this.annotationRegistry.hasReplacerFor(type);
    }

    @Override
    @Nullable
    public <A extends Annotation> AnnotationReplacer<A> getAnnotationReplacer(Class<A> type) {
        return this.annotationRegistry.getAnnotationReplacer(type);
    }
}

