/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.util;

import dev.velix.imperat.context.ArgumentQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    public static final char DOUBLE_QUOTE = '\"';
    public static final char SINGLE_QUOTE = '\'';
    public static final Pattern SNOWFLAKE = Pattern.compile("<(@!|@|@&|#)(?<snowflake>\\d{18})>");

    private StringUtils() {
    }

    @Nullable
    public static String getSnowflake(String mention) {
        Matcher matcher = SNOWFLAKE.matcher(mention);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    @NotNull
    public static String stripNamespace(@NotNull String command) {
        int colon = command.indexOf(58);
        if (colon == -1) {
            return command;
        }
        return command.substring(colon + 1);
    }

    public static String normalizedParameterFormatting(String parameterContent, boolean optional) {
        String suffix;
        String prefix;
        if (optional) {
            prefix = "[";
            suffix = "]";
        } else {
            prefix = "<";
            suffix = ">";
        }
        return prefix + parameterContent + suffix;
    }

    public static ArgumentQueue parseToQueue(String argumentsInOneLine, boolean autoCompletion, boolean extraSpace) {
        if (argumentsInOneLine.isEmpty()) {
            return !autoCompletion ? ArgumentQueue.empty(argumentsInOneLine) : ArgumentQueue.parse(" ");
        }
        ArgumentQueue toCollect = ArgumentQueue.empty(argumentsInOneLine);
        char[] chars = argumentsInOneLine.toCharArray();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (StringUtils.isQuoteChar(c) && i != chars.length - 1) {
                int start;
                for (start = i + 1; start < chars.length && !StringUtils.isEndOfQuote(c, chars[start]); ++start) {
                    builder.append(chars[start]);
                }
                i = start;
                toCollect.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            if (Character.isWhitespace(c)) {
                toCollect.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            builder.append(c);
        }
        if (!builder.isEmpty()) {
            toCollect.add(builder.toString());
        }
        if (autoCompletion && extraSpace) {
            toCollect.add(" ");
        }
        return toCollect;
    }

    public static ArgumentQueue parseToQueue(String argumentsInOneLine, boolean autoCompletion) {
        return StringUtils.parseToQueue(argumentsInOneLine, autoCompletion, false);
    }

    public static boolean isQuoteChar(char ch) {
        return ch == '\"' || ch == '\'';
    }

    public static boolean isEndOfQuote(char quoteStarter, char value) {
        return StringUtils.isQuoteChar(value) && StringUtils.isQuoteChar(quoteStarter) && quoteStarter == value;
    }
}

