/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.supplier;

import dev.velix.imperat.context.Source;
import dev.velix.imperat.util.Preconditions;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OptionalValueSupplier<T> {
    public static <T> OptionalValueSupplier<T> of(final @NotNull T def) {
        Preconditions.notNull(def, "default cannot be null, use `OptionalValueSupplier#empty` instead");
        return new OptionalValueSupplier<T>(){

            @Override
            public TypeWrap<T> getValueType() {
                return TypeWrap.of(def.getClass());
            }

            @Override
            public <S extends Source> T supply(S source) {
                return def;
            }
        };
    }

    @NotNull
    public static <T> OptionalValueSupplier<T> empty(final TypeWrap<T> type) {
        return new OptionalValueSupplier<T>(){

            @Override
            public TypeWrap<T> getValueType() {
                return type;
            }

            @Override
            @Nullable
            public <S extends Source> T supply(S source) {
                return null;
            }
        };
    }

    default public Type reflectionType() {
        return this.getValueType().getType();
    }

    public TypeWrap<T> getValueType();

    @Nullable
    public <S extends Source> T supply(S var1);
}

