/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.placeholders;

import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.placeholders.Placeholder;
import dev.velix.imperat.placeholders.PlaceholderResolver;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class PlaceholderImpl<S extends Source>
implements Placeholder<S> {
    private final String id;
    private final PlaceholderResolver<S> resolver;
    private final Pattern pattern;

    PlaceholderImpl(String id, PlaceholderResolver<S> resolver) {
        this.id = id;
        this.resolver = resolver;
        this.pattern = Pattern.compile(id);
    }

    @Override
    @NotNull
    public String id() {
        return this.id;
    }

    @Override
    @NotNull
    public PlaceholderResolver<S> resolver() {
        return this.resolver;
    }

    @Override
    public boolean isUsedIn(String input) {
        return this.pattern.matcher(input).find();
    }

    @Override
    public String replaceResolved(ImperatConfig<S> imperat, String id, String input) {
        assert (this.isUsedIn(input));
        return this.pattern.matcher(input).replaceAll(this.resolveInput(id, imperat));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PlaceholderImpl that = (PlaceholderImpl)obj;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

