/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.help;

import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.help.DefaultFormatter;
import dev.velix.imperat.help.HelpHyphen;
import dev.velix.imperat.help.HelpTemplate;
import dev.velix.imperat.help.HelpTemplateImpl;
import dev.velix.imperat.help.TemplatePagination;
import dev.velix.imperat.help.UsageDisplayer;
import dev.velix.imperat.help.UsageFormatter;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.AvailableSince(value="1.0.0")
public interface HelpProvider<S extends Source> {
    public void provide(ExecutionContext<S> var1, Source var2) throws ImperatException;

    default public void display(ExecutionContext<S> context, Source source, UsageFormatter formatter, Collection<? extends CommandUsage<S>> usages) throws ImperatException {
        int index = 0;
        for (CommandUsage<S> usage : usages) {
            source.reply(formatter.format(context.command(), usage, index));
            ++index;
        }
    }

    public static <S extends Source> NormalBuilder<S> template() {
        return new NormalBuilder();
    }

    public static <S extends Source> PaginationBuilder<S> paginated(int usagesPerPage) {
        return new PaginationBuilder(usagesPerPage);
    }

    public static final class NormalBuilder<S extends Source>
    extends Builder<S, HelpTemplate<S>, NormalBuilder<S>> {
        NormalBuilder() {
        }

        @Override
        protected HelpTemplate<S> createInstance() {
            return new HelpTemplateImpl(this.formatter, this.headerProvider, this.footerProvider, this.displayer);
        }
    }

    public static final class PaginationBuilder<S extends Source>
    extends Builder<S, HelpTemplate<S>, PaginationBuilder<S>> {
        private final int syntaxesPerPage;

        PaginationBuilder(int syntaxesPerPage) {
            this.syntaxesPerPage = syntaxesPerPage;
        }

        @Override
        protected HelpTemplate<S> createInstance() {
            return new TemplatePagination(new HelpTemplateImpl(this.formatter, this.headerProvider, this.footerProvider, this.displayer), this.syntaxesPerPage);
        }
    }

    public static abstract class Builder<S extends Source, T extends HelpProvider<S>, B extends Builder<S, T, B>> {
        protected UsageFormatter formatter = DefaultFormatter.INSTANCE;
        protected HelpHyphen<S> headerProvider;
        protected HelpHyphen<S> footerProvider;
        protected UsageDisplayer<S> displayer;

        protected Builder() {
        }

        @NotNull
        public B formatter(UsageFormatter formatter) {
            this.formatter = formatter;
            return (B)this;
        }

        @NotNull
        public B header(HelpHyphen<S> headerProvider) {
            this.headerProvider = headerProvider;
            return (B)this;
        }

        @NotNull
        public B footer(HelpHyphen<S> footerProvider) {
            this.footerProvider = footerProvider;
            return (B)this;
        }

        @NotNull
        public B displayer(UsageDisplayer<S> displayer) {
            this.displayer = displayer;
            return (B)this;
        }

        protected abstract T createInstance();

        public T build() {
            if (this.formatter == null) {
                return null;
            }
            return this.createInstance();
        }
    }
}

