/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.exception;

import dev.velix.imperat.command.parameters.NumericParameter;
import dev.velix.imperat.command.parameters.NumericRange;
import dev.velix.imperat.exception.SourceException;

public class NumberOutOfRangeException
extends SourceException {
    public NumberOutOfRangeException(NumericParameter<?> parameter, Number value, NumericRange range) {
        super("Value '" + String.valueOf(value) + "' entered for parameter '" + parameter.format() + "' must be " + NumberOutOfRangeException.formatRange(range), new Object[0]);
    }

    private static String formatRange(NumericRange range) {
        StringBuilder builder = new StringBuilder();
        if (range.getMin() != Double.MIN_VALUE && range.getMax() != Double.MAX_VALUE) {
            builder.append("within ").append(range.getMin()).append('-').append(range.getMax());
        } else if (range.getMin() != Double.MIN_VALUE) {
            builder.append("at least '").append(range.getMin()).append("'");
        } else if (range.getMax() != Double.MAX_VALUE) {
            builder.append("at most '").append(range.getMax()).append("'");
        } else {
            builder.append("(Open range)");
        }
        return builder.toString();
    }
}

