/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.tree;

import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.tree.ArgumentNode;
import dev.velix.imperat.command.tree.CommandNode;
import dev.velix.imperat.context.Source;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParameterNode<S extends Source, T extends CommandParameter<S>> {
    @NotNull
    protected final T data;
    private final LinkedList<ParameterNode<S, ?>> nextNodes = new LinkedList();

    protected ParameterNode(@NotNull T data) {
        this.data = data;
    }

    @NotNull
    public T getData() {
        return this.data;
    }

    public void addChild(ParameterNode<S, ?> node) {
        if (this.nextNodes.contains(node)) {
            return;
        }
        if (node.isCommand()) {
            this.nextNodes.addFirst(node);
        } else {
            this.nextNodes.addLast(node);
        }
    }

    public Collection<ParameterNode<S, ?>> getChildren() {
        return this.nextNodes;
    }

    public abstract boolean matchesInput(String var1);

    public abstract String format();

    public boolean isLast() {
        return this.nextNodes.isEmpty();
    }

    public abstract int priority();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isGreedyParam() {
        ParameterNode parameterNode = this;
        if (!(parameterNode instanceof ArgumentNode)) return false;
        ArgumentNode param = (ArgumentNode)parameterNode;
        if (!param.data.isGreedy()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOptional() {
        ParameterNode parameterNode = this;
        if (!(parameterNode instanceof ArgumentNode)) return false;
        ArgumentNode param = (ArgumentNode)parameterNode;
        if (!param.data.isOptional()) return false;
        return true;
    }

    @Nullable
    public ParameterNode<S, ?> getChild(Predicate<ParameterNode<S, ?>> predicate) {
        for (ParameterNode<S, ?> child : this.getChildren()) {
            if (!predicate.test(child)) continue;
            return child;
        }
        return null;
    }

    public ParameterNode<S, ?> getNextCommandChild() {
        return this.getChild(child -> child instanceof CommandNode);
    }

    public ParameterNode<S, ?> getNextParameterChild() {
        return this.getChild(child -> true);
    }

    public boolean isRequired() {
        return this.data.isRequired();
    }

    public boolean isCommand() {
        return this instanceof CommandNode || this.data.isCommand();
    }

    public boolean isTrueFlag() {
        return this.data.isFlag() && !this.data.asFlagParameter().isSwitch();
    }

    public boolean isFlag() {
        return this.data.isFlag();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParameterNode)) {
            return false;
        }
        ParameterNode that = (ParameterNode)o;
        return Objects.equals(this.data.name(), that.data.name()) && Objects.equals(this.nextNodes, that.nextNodes);
    }

    public int hashCode() {
        return Objects.hash(this.data.name(), this.nextNodes);
    }
}

