/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.util.Preconditions;
import dev.velix.imperat.util.TypeWrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterWord<S extends Source>
extends BaseParameterType<S, String> {
    private final List<String> restrictions = new ArrayList<String>();

    ParameterWord() {
        super(TypeWrap.of(String.class));
    }

    @Override
    @Nullable
    public String resolve(ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream) throws ImperatException {
        Optional<String> nextRaw = commandInputStream.currentRaw();
        if (this.restrictions.isEmpty()) {
            return nextRaw.orElse(null);
        }
        return nextRaw.filter(this.restrictions::contains).orElseThrow(() -> new SourceException("Word '%s' is not within the given restrictions=%s", nextRaw, this.restrictions.toString()));
    }

    @Override
    public boolean matchesInput(String input, CommandParameter<S> parameter) {
        if (!this.restrictions.isEmpty()) {
            return this.restrictions.contains(input);
        }
        return true;
    }

    @Override
    @NotNull
    public String fromString(Imperat<S> imperat, String input) {
        return input;
    }

    public ParameterWord<S> withRestriction(String restriction) {
        Preconditions.notNull(restriction, "not null");
        this.restrictions.add(restriction);
        return this;
    }

    public List<String> getRestrictions() {
        return this.restrictions;
    }
}

