/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.InvalidUUIDException;
import dev.velix.imperat.util.TypeWrap;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterUUID<S extends Source>
extends BaseParameterType<S, UUID> {
    public ParameterUUID() {
        super(TypeWrap.of(UUID.class));
    }

    @Override
    @Nullable
    public UUID resolve(ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream) throws ImperatException {
        String raw = commandInputStream.currentRaw().orElse(null);
        if (raw == null) {
            return null;
        }
        try {
            return UUID.fromString(raw);
        }
        catch (Exception ex) {
            throw new InvalidUUIDException(raw);
        }
    }

    @Override
    public boolean matchesInput(String input, CommandParameter<S> parameter) {
        try {
            UUID.fromString(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    @NotNull
    public UUID fromString(Imperat<S> imperat, String input) {
        return UUID.fromString(input);
    }
}

