/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.util.StringUtils;
import dev.velix.imperat.util.TypeWrap;
import org.jetbrains.annotations.NotNull;

public final class ParameterString<S extends Source>
extends BaseParameterType<S, String> {
    ParameterString() {
        super(TypeWrap.of(String.class));
    }

    @Override
    @NotNull
    public String resolve(ExecutionContext<S> context, @NotNull CommandInputStream<S> inputStream) throws ImperatException {
        Character next;
        StringBuilder builder = new StringBuilder();
        CommandParameter parameter = inputStream.currentParameter().orElse(null);
        Character current = inputStream.currentLetter().orElse(null);
        if (current == null) {
            return builder.toString();
        }
        if (!StringUtils.isQuoteChar(current.charValue())) {
            if (parameter != null && parameter.isGreedyString()) {
                this.handleGreedy(builder, inputStream);
            } else {
                builder.append(inputStream.currentRaw().orElse(""));
            }
            return builder.toString();
        }
        while ((next = (Character)inputStream.popLetter().orElse(null)) != null) {
            builder.append(next);
            if (inputStream.hasNextRaw() && inputStream.peekLetter().map(ch -> !StringUtils.isQuoteChar(ch.charValue())).orElse(false).booleanValue()) continue;
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String fromString(Imperat<S> imperat, String input) {
        return input;
    }

    private void handleGreedy(StringBuilder builder, CommandInputStream<S> inputStream) {
        String raw = inputStream.currentRaw().orElse(null);
        if (raw == null) {
            return;
        }
        while (inputStream.hasNextLetter()) {
            inputStream.currentLetter().ifPresent(builder::append);
            inputStream.skipLetter();
        }
    }
}

