/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.util.TypeWrap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayParameterType<S extends Source, E>
extends BaseParameterType<S, E[]> {
    private final Function<Integer, Object[]> initializer;
    private final ParameterType<S, E> componentType;

    public ArrayParameterType(TypeWrap<E[]> type, Function<Integer, Object[]> initializer, ParameterType<S, E> componentType) {
        super(type);
        this.initializer = initializer;
        this.componentType = componentType;
    }

    @Override
    public E @Nullable [] resolve(ExecutionContext<S> context, @NotNull CommandInputStream<S> stream) throws ImperatException {
        String raw;
        String currentRaw = stream.currentRaw().orElse(null);
        if (currentRaw == null) {
            return null;
        }
        int arrayLength = stream.rawsLength() - stream.currentRawPosition();
        Object[] array = this.initializer.apply(arrayLength);
        int i = 0;
        while (stream.hasNextRaw() && (raw = (String)stream.currentRaw().orElse(null)) != null) {
            array[i] = this.componentType.resolve(context, stream);
            stream.skipRaw();
            ++i;
        }
        return array;
    }

    @Override
    public E @NotNull [] fromString(Imperat<S> imperat, String input) {
        String[] split = input.split(" ");
        Object[] initializer = this.initializer.apply(split.length);
        for (int i = 0; i < split.length; ++i) {
            String raw = split[i];
            initializer[i] = this.componentType.fromString(imperat, raw);
        }
        return initializer;
    }
}

