/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters;

public final class NumericRange {
    private final double min;
    private final double max;

    NumericRange(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public static NumericRange of(double min, double max) {
        return new NumericRange(min, max);
    }

    public static NumericRange min(double min) {
        return new NumericRange(min, Double.MAX_VALUE);
    }

    public static NumericRange max(double max) {
        return new NumericRange(Double.MIN_VALUE, max);
    }

    public static NumericRange empty() {
        return NumericRange.of(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public boolean matches(double value) {
        return value >= this.min && value <= this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

