/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Type;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstrainedParameterTypeDecorator<S extends Source, T>
extends BaseParameterType<S, T> {
    private final ParameterType<S, T> original;
    private final boolean caseSensitive;
    private final Set<String> allowedValues;

    private ConstrainedParameterTypeDecorator(ParameterType<S, T> original, Set<String> allowedValues, boolean caseSensitive) {
        super(original.wrappedType());
        this.original = original;
        this.allowedValues = allowedValues;
        this.caseSensitive = caseSensitive;
        allowedValues.forEach(xva$0 -> original.withSuggestions((String)xva$0));
    }

    public static <S extends Source, T> ConstrainedParameterTypeDecorator<S, T> of(ParameterType<S, T> original, Set<String> allowedValues, boolean caseSensitive) {
        return new ConstrainedParameterTypeDecorator<S, T>(original, allowedValues, caseSensitive);
    }

    public static <S extends Source, T> ConstrainedParameterTypeDecorator<S, T> of(ParameterType<S, T> original, Set<String> allowedValues) {
        return new ConstrainedParameterTypeDecorator<S, T>(original, allowedValues, true);
    }

    @Override
    @Nullable
    public T resolve(ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream) throws ImperatException {
        String input = commandInputStream.currentRaw().orElse(null);
        if (input == null) {
            return this.original.resolve(context, commandInputStream);
        }
        if (ConstrainedParameterTypeDecorator.contains(input, this.allowedValues, this.caseSensitive)) {
            return this.original.resolve(context, commandInputStream);
        }
        throw new SourceException("Input '%s' is not one of: [" + String.join((CharSequence)",", this.allowedValues) + "]", input);
    }

    private static boolean contains(String input, Set<String> allowedValues, boolean caseSensitive) {
        if (caseSensitive) {
            return allowedValues.contains(input);
        }
        for (String value : allowedValues) {
            if (!input.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SuggestionResolver<S> getSuggestionResolver() {
        return this.original.getSuggestionResolver();
    }

    @Override
    public boolean isRelatedToType(Type type) {
        return this.original.isRelatedToType(type);
    }

    @Override
    public boolean equalsExactly(Type type) {
        return this.original.equalsExactly(type);
    }

    @Override
    public TypeWrap<T> wrappedType() {
        return this.original.wrappedType();
    }

    @Override
    @NotNull
    public T fromString(Imperat<S> imperat, String input) {
        return this.original.fromString(imperat, input);
    }
}

