/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters;

import dev.velix.imperat.annotations.parameters.AnnotatedParameter;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.Description;
import dev.velix.imperat.command.DescriptionHolder;
import dev.velix.imperat.command.PermissionHolder;
import dev.velix.imperat.command.parameters.FlagBuilder;
import dev.velix.imperat.command.parameters.FlagParameter;
import dev.velix.imperat.command.parameters.NormalCommandParameter;
import dev.velix.imperat.command.parameters.NumericParameter;
import dev.velix.imperat.command.parameters.ParameterBuilder;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.command.parameters.type.ParameterTypes;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.supplier.OptionalValueSupplier;
import dev.velix.imperat.util.Preconditions;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Type;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.AvailableSince(value="1.0.0")
public interface CommandParameter<S extends Source>
extends PermissionHolder,
DescriptionHolder {
    public static <S extends Source, T> CommandParameter<S> of(String name, ParameterType<S, T> type, @Nullable String permission, Description description, boolean optional, boolean greedy, @NotNull OptionalValueSupplier<T> valueSupplier, @Nullable SuggestionResolver<S> suggestionResolver) {
        Preconditions.notNull(name, "name");
        Preconditions.notNull(type, "type");
        Preconditions.checkArgument(!type.equalsExactly((Type)((Object)Object.class)), "Type cannot be `Object`");
        return new NormalCommandParameter<S>(name, type, permission, description, optional, greedy, valueSupplier, suggestionResolver);
    }

    public static <S extends Source, T> ParameterBuilder<S, T> required(String name, ParameterType<S, T> type) {
        return new ParameterBuilder<S, T>(name, type, false);
    }

    public static <S extends Source> ParameterBuilder<S, Integer> requiredInt(String name) {
        return CommandParameter.required(name, ParameterTypes.numeric(Integer.class));
    }

    public static <S extends Source> ParameterBuilder<S, Long> requiredLong(String name) {
        return CommandParameter.required(name, ParameterTypes.numeric(Long.class));
    }

    public static <S extends Source> ParameterBuilder<S, Double> requiredDouble(String name) {
        return CommandParameter.required(name, ParameterTypes.numeric(Double.class));
    }

    public static <S extends Source> ParameterBuilder<S, Float> requiredFloat(String name) {
        return CommandParameter.required(name, ParameterTypes.numeric(Float.class));
    }

    public static <S extends Source> ParameterBuilder<S, Boolean> requiredBoolean(String name) {
        return CommandParameter.required(name, ParameterTypes.bool());
    }

    public static <S extends Source> ParameterBuilder<S, String> requiredText(String name) {
        return CommandParameter.required(name, ParameterTypes.string());
    }

    public static <S extends Source> ParameterBuilder<S, String> requiredGreedy(String name) {
        return new ParameterBuilder(name, ParameterTypes.string(), false, true);
    }

    public static <S extends Source, T> ParameterBuilder<S, T> optional(String name, ParameterType<S, T> token) {
        return new ParameterBuilder<S, T>(name, token, true);
    }

    public static <S extends Source> ParameterBuilder<S, Integer> optionalInt(String name) {
        return CommandParameter.optional(name, ParameterTypes.numeric(Integer.class));
    }

    public static <S extends Source> ParameterBuilder<S, Long> optionalLong(String name) {
        return CommandParameter.optional(name, ParameterTypes.numeric(Long.class));
    }

    public static <S extends Source> ParameterBuilder<S, Double> optionalDouble(String name) {
        return CommandParameter.optional(name, ParameterTypes.numeric(Double.class));
    }

    public static <S extends Source> ParameterBuilder<S, Float> optionalFloat(String name) {
        return CommandParameter.optional(name, ParameterTypes.numeric(Float.class));
    }

    public static <S extends Source> ParameterBuilder<S, Boolean> optionalBoolean(String name) {
        return CommandParameter.optional(name, ParameterTypes.bool());
    }

    public static <S extends Source> ParameterBuilder<S, String> optionalText(String name) {
        return CommandParameter.optional(name, ParameterTypes.string());
    }

    public static <S extends Source> ParameterBuilder<S, String> optionalGreedy(String name) {
        return new ParameterBuilder(name, ParameterTypes.string(), true, true);
    }

    public static <S extends Source, T> FlagBuilder<S, T> flag(String name, ParameterType<S, T> inputType) {
        return FlagBuilder.ofFlag(name, inputType);
    }

    public static <S extends Source> FlagBuilder<S, Boolean> flagSwitch(String name) {
        return FlagBuilder.ofSwitch(name);
    }

    public String name();

    @Nullable
    public Command<S> parent();

    public void parent(Command<S> var1);

    public int position();

    @ApiStatus.Internal
    public void position(int var1);

    public TypeWrap<?> wrappedType();

    default public Type valueType() {
        return this.wrappedType().getType();
    }

    @NotNull
    public ParameterType<S, ?> type();

    @NotNull
    public <T> OptionalValueSupplier<T> getDefaultValueSupplier();

    public boolean isOptional();

    public boolean isFlag();

    public FlagParameter<S> asFlagParameter();

    public boolean isGreedy();

    public boolean isGreedyString();

    default public boolean isCommand() {
        return this instanceof Command;
    }

    public Command<S> asCommand();

    default public boolean isAnnotated() {
        return this instanceof AnnotatedParameter;
    }

    default public AnnotatedParameter<S> asAnnotated() {
        return (AnnotatedParameter)this;
    }

    @Nullable
    public SuggestionResolver<S> getSuggestionResolver();

    public String format();

    default public boolean isNumeric() {
        return this instanceof NumericParameter;
    }

    default public NumericParameter<S> asNumeric() {
        return (NumericParameter)this;
    }

    public boolean similarTo(CommandParameter<?> var1);

    default public boolean isRequired() {
        return !this.isOptional();
    }
}

