/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.CommandCoordinator;
import dev.velix.imperat.command.CommandExecution;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.Description;
import dev.velix.imperat.command.cooldown.CooldownHandler;
import dev.velix.imperat.command.cooldown.UsageCooldown;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.util.Patterns;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class CommandUsageImpl<S extends Source>
implements CommandUsage<S> {
    private final List<CommandParameter<S>> parameters = new ArrayList<CommandParameter<S>>();
    private final List<CommandParameter<S>> parametersWithoutFlags = new ArrayList<CommandParameter<S>>();
    @NotNull
    private final CommandExecution<S> execution;
    private final boolean help;
    private String permission = null;
    private Description description = Description.of("N/A");
    @NotNull
    private CooldownHandler<S> cooldownHandler;
    @Nullable
    private UsageCooldown cooldown = null;
    private CommandCoordinator<S> commandCoordinator;
    private final Set<FlagData<S>> freeflags = new HashSet<FlagData<S>>();

    CommandUsageImpl(@NotNull CommandExecution<S> execution) {
        this(execution, false);
    }

    CommandUsageImpl(@NotNull CommandExecution<S> execution, boolean help) {
        this.execution = execution;
        this.cooldownHandler = CooldownHandler.createDefault(this);
        this.commandCoordinator = CommandCoordinator.sync();
        this.help = help;
    }

    @Override
    @Nullable
    public String permission() {
        return this.permission;
    }

    @Override
    public void permission(String permission) {
        this.permission = permission;
    }

    @Override
    public Description description() {
        return this.description;
    }

    @Override
    public void describe(Description description) {
        this.description = description;
    }

    @Override
    public boolean hasFlag(String input) {
        return this.getFlagParameterFromRaw(input) != null;
    }

    @Override
    @Nullable
    public FlagData<S> getFlagParameterFromRaw(String rawInput) {
        boolean isSingle = Patterns.SINGLE_FLAG.matcher(rawInput).matches();
        boolean isDouble = Patterns.DOUBLE_FLAG.matcher(rawInput).matches();
        if (!isSingle && !isDouble) {
            return null;
        }
        String inputFlagAlias = rawInput.substring(isSingle ? 1 : 2);
        for (CommandParameter<S> param : this.parameters) {
            FlagData<S> flag;
            if (!param.isFlag() || !(flag = param.asFlagParameter().flagData()).acceptsInput(inputFlagAlias)) continue;
            return flag;
        }
        return null;
    }

    @Override
    public void addFlag(CommandParameter<S> flagParam) {
        this.freeflags.add(flagParam.asFlagParameter().flagData());
    }

    @Override
    public void addFlag(FlagData<S> flagData) {
        this.freeflags.add(flagData);
    }

    @Override
    public Set<FlagData<S>> getUsedFreeFlags() {
        return this.freeflags;
    }

    @Override
    @SafeVarargs
    public final void addParameters(CommandParameter<S> ... params) {
        this.addParameters(Arrays.asList(params));
    }

    @Override
    public void addParameters(List<CommandParameter<S>> params) {
        for (CommandParameter<S> param : params) {
            if (param.isFlag() && param.asFlagParameter().flagData().isFree()) {
                this.freeflags.add(param.asFlagParameter().flagData());
                continue;
            }
            this.parameters.add(param);
            if (param.isFlag()) continue;
            this.parametersWithoutFlags.add(param);
        }
    }

    @Override
    public List<CommandParameter<S>> getParameters() {
        return this.parameters;
    }

    @Override
    public List<CommandParameter<S>> getParametersWithoutFlags() {
        return this.parametersWithoutFlags;
    }

    @Override
    @Nullable
    public CommandParameter<S> getParameter(int index) {
        if (index < 0 || index >= this.parameters.size()) {
            return null;
        }
        return this.parameters.get(index);
    }

    @Override
    @NotNull
    public CommandExecution<S> getExecution() {
        return this.execution;
    }

    @Override
    public boolean hasParamType(Class<?> clazz) {
        return this.getParameters().stream().anyMatch(param -> param.valueType().equals(clazz));
    }

    @Override
    public int getMinLength() {
        return (int)this.getParameters().stream().filter(param -> !param.isFlag()).filter(param -> !param.isOptional()).count();
    }

    @Override
    public int getMaxLength() {
        return this.getParameters().size();
    }

    @Override
    public boolean hasParameters(Predicate<CommandParameter<S>> parameterPredicate) {
        for (CommandParameter<S> parameter : this.getParameters()) {
            if (!parameterPredicate.test(parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public CommandParameter<S> getParameter(Predicate<CommandParameter<S>> parameterPredicate) {
        for (CommandParameter<S> parameter : this.getParameters()) {
            if (!parameterPredicate.test(parameter)) continue;
            return parameter;
        }
        return null;
    }

    @Override
    @Nullable
    public UsageCooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(@Nullable UsageCooldown usageCooldown) {
        this.cooldown = usageCooldown;
    }

    @Override
    @NotNull
    public CooldownHandler<S> getCooldownHandler() {
        return this.cooldownHandler;
    }

    @Override
    public void setCooldownHandler(@NotNull CooldownHandler<S> cooldownHandler) {
        this.cooldownHandler = cooldownHandler;
    }

    @Override
    public CommandCoordinator<S> getCoordinator() {
        return this.commandCoordinator;
    }

    @Override
    public void setCoordinator(CommandCoordinator<S> commandCoordinator) {
        this.commandCoordinator = commandCoordinator;
    }

    @Override
    public void execute(Imperat<S> imperat, S source, ExecutionContext<S> context) {
        this.commandCoordinator.coordinate(imperat, source, context, this.execution);
    }

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public boolean hasParameters(List<CommandParameter<S>> parameters) {
        if (this.parameters.size() != parameters.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            CommandParameter<S> otherParam;
            CommandParameter<S> thisParam = this.parameters.get(i);
            if (thisParam.similarTo(otherParam = parameters.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandUsageImpl that = (CommandUsageImpl)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            CommandParameter<S> thisP = this.getParameter(i);
            CommandParameter<S> thatP = that.getParameter(i);
            assert (thisP != null);
            if (thisP.similarTo(thatP)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }
}

