/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.CommandExecution;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommandCoordinator<S extends Source> {
    public static <S extends Source> CommandCoordinator<S> sync() {
        return (api, source, context, execution) -> {
            try {
                execution.execute(source, context);
            }
            catch (Exception ex) {
                api.config().handleExecutionThrowable(ex, context, CommandCoordinator.class, "sync-lambda");
            }
        };
    }

    public static <S extends Source> CommandCoordinator<S> async(@Nullable ExecutorService service) {
        return (api, source, context, execution) -> {
            ExecutorService executorService = service;
            if (executorService == null) {
                executorService = ForkJoinPool.commonPool();
            }
            CompletableFuture.runAsync(() -> {
                try {
                    execution.execute(source, context);
                }
                catch (Exception e) {
                    api.config().handleExecutionThrowable(e, context, CommandCoordinator.class, "async-lambda");
                }
            }, executorService);
        };
    }

    public static <S extends Source> CommandCoordinator<S> async() {
        return CommandCoordinator.async(null);
    }

    public void coordinate(@NotNull Imperat<S> var1, @NotNull S var2, @NotNull ExecutionContext<S> var3, @NotNull CommandExecution<S> var4);
}

