/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command;

import dev.velix.imperat.FlagRegistrar;
import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.CommandExecution;
import dev.velix.imperat.command.CommandImpl;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.Description;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.command.parameters.type.ParameterTypes;
import dev.velix.imperat.command.processors.CommandPostProcessor;
import dev.velix.imperat.command.processors.CommandPreProcessor;
import dev.velix.imperat.command.suggestions.AutoCompleter;
import dev.velix.imperat.command.tree.CommandDispatch;
import dev.velix.imperat.command.tree.CommandTree;
import dev.velix.imperat.context.Context;
import dev.velix.imperat.context.ResolvedContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.supplier.OptionalValueSupplier;
import dev.velix.imperat.util.TypeWrap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.AvailableSince(value="1.0.0")
public interface Command<S extends Source>
extends CommandParameter<S>,
FlagRegistrar<S> {
    public static <S extends Source> Builder<S> create(String name) {
        return Command.create(null, name);
    }

    public static <S extends Source> Builder<S> create(@Nullable Command<S> parent, @NotNull String name) {
        return Command.create(parent, 0, name);
    }

    public static <S extends Source> Builder<S> create(@Nullable Command<S> parent, int position, @NotNull String name) {
        return new Builder<S>(parent, position, name);
    }

    @Override
    public String name();

    @Override
    @NotNull
    public Description description();

    public @UnmodifiableView List<String> aliases();

    public CommandTree<S> tree();

    public void addAliases(List<String> var1);

    default public void addAliases(String ... aliases) {
        this.addAliases(List.of(aliases));
    }

    @Override
    @NotNull
    default public ParameterType<S, ?> type() {
        return ParameterTypes.command(this.name(), this.aliases());
    }

    @Override
    @ApiStatus.Internal
    default public void position(int position) {
        throw new UnsupportedOperationException("You can't modify the position of a command");
    }

    @Override
    @NotNull
    default public <T> OptionalValueSupplier<T> getDefaultValueSupplier() {
        return OptionalValueSupplier.of(this.name());
    }

    default public boolean hasName(String name) {
        return this.name().equalsIgnoreCase(name) || this.aliases().contains(name.toLowerCase());
    }

    @NotNull
    public CommandDispatch<S> contextMatch(Context<S> var1);

    public void visualizeTree();

    public void setPreProcessor(@NotNull CommandPreProcessor<S> var1);

    public void preProcess(@NotNull Imperat<S> var1, @NotNull Context<S> var2, @NotNull CommandUsage<S> var3) throws ImperatException;

    public void setPostProcessor(@NotNull CommandPostProcessor<S> var1);

    public void postProcess(@NotNull Imperat<S> var1, @NotNull ResolvedContext<S> var2, @NotNull CommandUsage<S> var3) throws ImperatException;

    @NotNull
    public CommandUsage<S> getDefaultUsage();

    public void setDefaultUsageExecution(CommandExecution<S> var1);

    public void addUsage(CommandUsage<S> var1);

    default public void addUsage(CommandUsage.Builder<S> builder, boolean help) {
        this.addUsage(builder.build(this, help));
    }

    default public void addUsage(CommandUsage.Builder<S> builder) {
        this.addUsage(builder, false);
    }

    @Nullable
    public CommandUsage<S> getUsage(List<CommandParameter<S>> var1);

    public Collection<? extends CommandUsage<S>> usages();

    public Collection<? extends CommandUsage<S>> findUsages(Predicate<CommandUsage<S>> var1);

    @NotNull
    public CommandUsage<S> mainUsage();

    public AutoCompleter<S> autoCompleter();

    public void addSubCommand(Command<S> var1, boolean var2);

    public void addSubCommandUsage(String var1, List<String> var2, CommandUsage.Builder<S> var3, boolean var4);

    default public void addSubCommandUsage(String subCommand, List<String> aliases, CommandUsage.Builder<S> usage) {
        this.addSubCommandUsage(subCommand, aliases, usage, false);
    }

    default public void addSubCommandUsage(String subCommand, CommandUsage.Builder<S> usage, boolean attachDirectly) {
        this.addSubCommandUsage(subCommand, Collections.emptyList(), usage, attachDirectly);
    }

    default public void addSubCommandUsage(String subCommand, CommandUsage.Builder<S> usage) {
        this.addSubCommandUsage(subCommand, usage, false);
    }

    @Nullable
    public Command<S> getSubCommand(String var1);

    @NotNull
    public Collection<? extends Command<S>> getSubCommands();

    @Nullable
    default public CommandUsage<S> getUsage(Predicate<CommandUsage<S>> usagePredicate) {
        for (CommandUsage<S> usage : this.usages()) {
            if (!usagePredicate.test(usage)) continue;
            return usage;
        }
        return null;
    }

    default public boolean hasParent() {
        return this.parent() != null;
    }

    default public boolean isSubCommand() {
        return this.hasParent();
    }

    @Override
    default public TypeWrap<?> wrappedType() {
        return TypeWrap.of(Command.class);
    }

    @Override
    default public boolean isOptional() {
        return false;
    }

    @Override
    default public boolean isGreedy() {
        return false;
    }

    @Override
    default public boolean isFlag() {
        return false;
    }

    @Override
    default public Command<S> asCommand() {
        return this;
    }

    @Override
    default public String format() {
        return this.name();
    }

    public boolean isIgnoringACPerms();

    public void ignoreACPermissions(boolean var1);

    public void addHelpCommand(Imperat<S> var1, List<CommandParameter<S>> var2, CommandExecution<S> var3);

    public static class Builder<S extends Source> {
        private final Command<S> cmd;

        Builder(@Nullable Command<S> parent, int position, String name) {
            this.cmd = new CommandImpl<S>(parent, position, name);
        }

        public Builder<S> ignoreACPermissions(boolean ignore) {
            this.cmd.ignoreACPermissions(ignore);
            return this;
        }

        public Builder<S> aliases(String ... aliases) {
            this.cmd.addAliases(aliases);
            return this;
        }

        public Builder<S> aliases(List<String> aliases) {
            this.cmd.addAliases(aliases);
            return this;
        }

        public Builder<S> description(String description) {
            this.cmd.describe(description);
            return this;
        }

        public Builder<S> description(Description description) {
            return this.description(description.toString());
        }

        public Builder<S> permission(String permission) {
            this.cmd.permission(permission);
            return this;
        }

        public Builder<S> defaultExecution(CommandExecution<S> defaultExec) {
            this.cmd.setDefaultUsageExecution(defaultExec);
            return this;
        }

        public Builder<S> usage(CommandUsage.Builder<S> usage) {
            this.cmd.addUsage(usage);
            return this;
        }

        public Builder<S> subCommand(Command<S> subCommand, boolean attachDirectly) {
            this.cmd.addSubCommand(subCommand, attachDirectly);
            return this;
        }

        public Builder<S> subCommand(Command<S> subCommand) {
            return this.subCommand(subCommand, false);
        }

        public Builder<S> subCommand(String name, CommandUsage.Builder<S> mainUsage, boolean attachDirectly) {
            return this.subCommand(Command.create(name).usage(mainUsage).build(), attachDirectly);
        }

        public Builder<S> subCommand(String name, CommandUsage.Builder<S> mainUsage) {
            return this.subCommand(name, mainUsage, false);
        }

        public Builder<S> preProcessor(CommandPreProcessor<S> preProcessor) {
            this.cmd.setPreProcessor(preProcessor);
            return this;
        }

        public Builder<S> postProcessor(CommandPostProcessor<S> postProcessor) {
            this.cmd.setPostProcessor(postProcessor);
            return this;
        }

        public Command<S> build() {
            return this.cmd;
        }
    }
}

