/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat;

import dev.velix.imperat.command.ContextResolverFactory;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.placeholders.Placeholder;
import dev.velix.imperat.resolvers.ContextResolver;
import dev.velix.imperat.resolvers.SourceResolver;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ResolverRegistrar<S extends Source> {
    public <T> void registerContextResolverFactory(Type var1, ContextResolverFactory<S, T> var2);

    public <T> void registerContextResolver(Type var1, @NotNull ContextResolver<S, T> var2);

    public <T> void registerParamType(Class<T> var1, @NotNull ParameterType<S, T> var2);

    public <C extends Collection<?>> void registerCollectionInitializer(Class<C> var1, Supplier<C> var2);

    public <M extends Map<?, ?>> void registerMapInitializer(Class<M> var1, Supplier<M> var2);

    @NotNull
    default public SuggestionResolver<S> getParameterSuggestionResolver(CommandParameter<S> parameter) {
        SuggestionResolver<S> parameterSpecificResolver = parameter.getSuggestionResolver();
        if (parameterSpecificResolver == null) {
            ImperatDebugger.debug("Found no specific argument suggestion resolver for param '%s'", parameter.format());
            SuggestionResolver<S> resolverByType = parameter.type().getSuggestionResolver();
            if (resolverByType != null) {
                ImperatDebugger.debug("Found resolver by type for param '%s'", parameter.format());
            } else {
                ImperatDebugger.debug("Resolving suggestion in the form of the parameter's literal format !", new Object[0]);
            }
            return Objects.requireNonNullElseGet(resolverByType, () -> SuggestionResolver.plain(Collections.singletonList(parameter.format())));
        }
        ImperatDebugger.debug("Found specific parameter suggestion for param '%s'", parameter.format());
        return parameterSpecificResolver;
    }

    @Nullable
    public SuggestionResolver<S> getSuggestionResolverByType(Type var1);

    @Nullable
    public SuggestionResolver<S> getNamedSuggestionResolver(String var1);

    public void registerNamedSuggestionResolver(String var1, SuggestionResolver<S> var2);

    @Nullable
    public <R> SourceResolver<S, R> getSourceResolver(Type var1);

    default public <R> void registerSourceResolver(TypeWrap<R> type, SourceResolver<S, R> sourceResolver) {
        this.registerSourceResolver(type.getType(), sourceResolver);
    }

    public <R> void registerSourceResolver(Type var1, SourceResolver<S, R> var2);

    public void registerPlaceholder(Placeholder<S> var1);
}

