/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.annotations.base.AnnotationParser;
import dev.velix.imperat.annotations.base.AnnotationReplacer;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.processors.CommandPostProcessor;
import dev.velix.imperat.command.processors.CommandPreProcessor;
import dev.velix.imperat.command.tree.CommandDispatch;
import dev.velix.imperat.context.ArgumentQueue;
import dev.velix.imperat.context.Context;
import dev.velix.imperat.context.ResolvedContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.AmbiguousUsageAdditionException;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.InvalidCommandUsageException;
import dev.velix.imperat.exception.InvalidSyntaxException;
import dev.velix.imperat.exception.PermissionDeniedException;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.Preconditions;
import dev.velix.imperat.util.TypeWrap;
import dev.velix.imperat.verification.UsageVerifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseImperat<S extends Source>
implements Imperat<S> {
    protected final ImperatConfig<S> config;
    @NotNull
    private AnnotationParser<S> annotationParser;
    private final Map<String, Command<S>> commands = new HashMap<String, Command<S>>();

    protected BaseImperat(@NotNull ImperatConfig<S> config) {
        this.config = config;
        this.annotationParser = AnnotationParser.defaultParser(this);
    }

    @Override
    public ImperatConfig<S> config() {
        return this.config;
    }

    @Override
    public boolean canBeSender(Type type) {
        return TypeWrap.of(Source.class).isSupertypeOf(type);
    }

    @Override
    public void registerCommand(Command<S> command) {
        try {
            UsageVerifier<S> verifier = this.config.getUsageVerifier();
            for (CommandUsage<S> usage : command.usages()) {
                if (!verifier.verify(usage)) {
                    throw new InvalidCommandUsageException(command, usage);
                }
                for (CommandUsage<S> other : command.usages()) {
                    if (other.equals(usage) || !verifier.areAmbiguous(usage, other)) continue;
                    throw new AmbiguousUsageAdditionException(command, usage, other);
                }
            }
            this.commands.put(command.name().toLowerCase(), command);
        }
        catch (RuntimeException ex) {
            ImperatDebugger.error(BaseImperat.class, "registerCommand(CommandProcessingChain command)", ex);
            this.shutdownPlatform();
        }
    }

    @Override
    public void registerCommand(Object command) {
        if (command instanceof Command) {
            Command commandObj = (Command)command;
            this.registerCommand(commandObj);
            return;
        }
        this.annotationParser.parseCommandClass(command);
    }

    @Override
    public void unregisterCommand(String name) {
        Preconditions.notNull(name, "commandToRemove");
        this.commands.remove(name.toLowerCase());
    }

    @Override
    public void unregisterAllCommands() {
        this.commands.clear();
    }

    @Override
    @Nullable
    public Command<S> getCommand(String name) {
        String cmdName = name.toLowerCase();
        Command<S> result = this.commands.get(cmdName);
        if (result != null) {
            return result;
        }
        for (Command<S> headCommands : this.commands.values()) {
            if (!headCommands.hasName(cmdName)) continue;
            return headCommands;
        }
        return null;
    }

    @Override
    public void setAnnotationParser(AnnotationParser<S> parser) {
        Preconditions.notNull(parser, "Parser");
        this.annotationParser = parser;
    }

    @Override
    @SafeVarargs
    public final void registerAnnotations(Class<? extends Annotation> ... type) {
        this.annotationParser.registerAnnotations(type);
    }

    @Override
    public <A extends Annotation> void registerAnnotationReplacer(Class<A> type, AnnotationReplacer<A> replacer) {
        this.annotationParser.registerAnnotationReplacer(type, replacer);
    }

    @Override
    @Nullable
    public Command<S> getSubCommand(String owningCommand, String name) {
        Command<S> owningCmd = this.getCommand(owningCommand);
        if (owningCmd == null) {
            return null;
        }
        for (Command<S> subCommand : owningCmd.getSubCommands()) {
            Command<S> result = this.search(subCommand, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @ApiStatus.Internal
    private Command<S> search(Command<S> sub, String name) {
        if (sub.hasName(name)) {
            return sub;
        }
        Iterator<Command<S>> iterator = sub.getSubCommands().iterator();
        if (iterator.hasNext()) {
            Command<S> other = iterator.next();
            if (other.hasName(name)) {
                return other;
            }
            return this.search(other, name);
        }
        return null;
    }

    @Override
    @NotNull
    public CommandDispatch.Result dispatch(Context<S> context) {
        try {
            return this.handleExecution(context);
        }
        catch (Throwable ex) {
            this.config.handleExecutionThrowable(ex, context, BaseImperat.class, "dispatch");
            return CommandDispatch.Result.UNKNOWN;
        }
    }

    @Override
    @NotNull
    public CommandDispatch.Result dispatch(S source, Command<S> command, String commandName, String[] rawInput) {
        ArgumentQueue rawArguments = ArgumentQueue.parse(rawInput);
        Context<S> plainContext = this.config.getContextFactory().createContext(this, source, command, commandName, rawArguments);
        return this.dispatch(plainContext);
    }

    @Override
    @NotNull
    public CommandDispatch.Result dispatch(S source, String commandName, String[] rawInput) {
        Command<S> command = this.getCommand(commandName);
        if (command == null) {
            source.error("Unknown command input: '" + commandName + "'");
            return CommandDispatch.Result.UNKNOWN;
        }
        command.visualizeTree();
        return this.dispatch(source, command, commandName, rawInput);
    }

    @Override
    @NotNull
    public CommandDispatch.Result dispatch(S sender, String commandName, String rawArgsOneLine) {
        return this.dispatch(sender, commandName, rawArgsOneLine.split(" "));
    }

    @Override
    public CommandDispatch.Result dispatch(S sender, String line) {
        String[] lineArgs = line.split(" ");
        String[] argumentsOnly = new String[lineArgs.length - 1];
        System.arraycopy(lineArgs, 1, argumentsOnly, 0, lineArgs.length - 1);
        return this.dispatch(sender, lineArgs[0], argumentsOnly);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CommandDispatch.Result handleExecution(Context<S> context) throws ImperatException {
        Command<S> command = context.command();
        S source = context.source();
        if (!this.config.getPermissionResolver().hasPermission(source, command.permission())) {
            throw new PermissionDeniedException();
        }
        if (context.arguments().isEmpty()) {
            CommandUsage<S> defaultUsage = command.getDefaultUsage();
            this.executeUsage(command, source, context, defaultUsage);
            return CommandDispatch.Result.INCOMPLETE;
        }
        CommandDispatch<S> searchResult = command.contextMatch(context);
        searchResult.visualize();
        CommandUsage<S> usage = searchResult.toUsage(command);
        if (searchResult.result() == CommandDispatch.Result.COMPLETE) {
            if (usage == null) {
                throw new InvalidSyntaxException();
            }
            ImperatDebugger.debug("Executing usage '%s'", CommandUsage.format(command, usage));
            this.executeUsage(command, source, context, usage);
            return searchResult.result();
        } else {
            if (searchResult.result() != CommandDispatch.Result.INCOMPLETE) throw new InvalidSyntaxException();
            if (searchResult.getLastParameter().isCommand()) {
                ImperatDebugger.debug("Executing last parameter as a sub command", new Object[0]);
                CommandUsage<S> defUsage = searchResult.getLastParameter().asCommand().getDefaultUsage();
                this.executeUsage(command, source, context, defUsage);
                return searchResult.result();
            } else {
                if (usage == null) throw new InvalidSyntaxException();
                ImperatDebugger.debug("Executing usage '%s'", CommandUsage.format(command, usage));
                this.executeUsage(command, source, context, usage);
            }
        }
        return searchResult.result();
    }

    private void executeUsage(Command<S> command, S source, Context<S> context, CommandUsage<S> usage) throws ImperatException {
        this.preProcess(context, usage);
        command.preProcess(this, context, usage);
        ResolvedContext<S> resolvedContext = this.config.getContextFactory().createResolvedContext(context, usage);
        resolvedContext.resolve();
        resolvedContext.debug();
        this.postProcess(resolvedContext);
        command.postProcess(this, resolvedContext, usage);
        usage.execute(this, source, resolvedContext);
    }

    private void preProcess(@NotNull Context<S> context, @NotNull CommandUsage<S> usage) {
        for (CommandPreProcessor preProcessor : this.config.getPreProcessors()) {
            try {
                preProcessor.process(this, context, usage);
            }
            catch (Throwable ex) {
                this.config.handleExecutionThrowable(ex, context, preProcessor.getClass(), "CommandPreProcessor#process");
                break;
            }
        }
    }

    private void postProcess(@NotNull ResolvedContext<S> context) {
        for (CommandPostProcessor postProcessor : this.config.getPostProcessors()) {
            try {
                postProcessor.process(this, context);
            }
            catch (Throwable ex) {
                this.config.handleExecutionThrowable(ex, context, postProcessor.getClass(), "CommandPostProcessor#process");
                break;
            }
        }
    }

    @Override
    public CompletableFuture<List<String>> autoComplete(Command<S> command, S source, String label, String[] args) {
        return command.autoCompleter().autoComplete(this, source, label, args);
    }

    @Override
    public Collection<? extends Command<S>> getRegisteredCommands() {
        return this.commands.values();
    }

    @Override
    public void debug(boolean treeVisualizing) {
        for (Command<S> cmd : this.commands.values()) {
            if (treeVisualizing) {
                cmd.visualizeTree();
                continue;
            }
            ImperatDebugger.debug("Debugging command '%s'", cmd.name());
            for (CommandUsage<S> usage : cmd.usages()) {
                ImperatDebugger.debug("   - '%s'", CommandUsage.format(cmd, usage));
            }
        }
    }
}

