/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.util.text;

import dev.velix.imperat.util.text.TextPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaginatedText<T> {
    private final List<T> objects = new ArrayList<T>();
    private final int itemsPerPage;
    @NotNull
    private final Map<Integer, TextPage<T>> pages = new HashMap<Integer, TextPage<T>>();

    public PaginatedText(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public int getMaxPages() {
        return this.pages.size();
    }

    @Nullable
    public TextPage<T> getPage(int index) {
        return this.pages.get(index);
    }

    public void add(T convertible) {
        this.objects.add(convertible);
    }

    public void paginate() {
        for (int i = 1; i <= this.objects.size(); ++i) {
            T obj = this.objects.get(i - 1);
            int page = (int)Math.ceil((double)i / (double)this.itemsPerPage);
            this.pages.compute(page, (index, existingPage) -> {
                if (existingPage == null) {
                    ArrayList<Object> list = new ArrayList<Object>(this.itemsPerPage);
                    list.add(obj);
                    return new TextPage(page, this.itemsPerPage, list);
                }
                existingPage.add(obj);
                return existingPage;
            });
        }
    }

    public void clear() {
        this.objects.clear();
        this.pages.clear();
    }
}

