/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.util;

import dev.velix.imperat.util.TypeVisitor;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public final class TypeUtility {
    static Set<Type> NUMERIC_PRIMITIVES = Set.of(Short.TYPE, Byte.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    static Map<Type, Type> PRIMITIVES_TO_BOXED = Map.of(Boolean.TYPE, Boolean.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Byte.TYPE, Byte.class);
    static Map<Type, Type> BOXED_TO_PRIMITIVES = Map.of(Boolean.class, Boolean.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Byte.class, Byte.TYPE);

    private TypeUtility() {
    }

    public static boolean isInteger(String string) {
        if (string == null) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isBoolean(String string) {
        if (string == null) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public static boolean isFloat(String input) {
        try {
            Float.parseFloat(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isDouble(String str) {
        if (str == null) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isShort(String str) {
        if (str == null) {
            return false;
        }
        try {
            Short.parseShort(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isByte(String str) {
        if (str == null) {
            return false;
        }
        try {
            Byte.parseByte(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLong(String str) {
        if (str == null) {
            return false;
        }
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNumericType(Class<?> type) {
        return Number.class.isAssignableFrom(type) || NUMERIC_PRIMITIVES.contains(type);
    }

    public static boolean isNumericType(TypeWrap<?> token) {
        return NUMERIC_PRIMITIVES.contains(token.unwrap().getType());
    }

    public static boolean isPrimitive(Type type) {
        return PRIMITIVES_TO_BOXED.get(type) != null;
    }

    public static boolean isBoxed(Type type) {
        return BOXED_TO_PRIMITIVES.get(type) != null;
    }

    @NotNull
    public static Type primitiveToBoxed(Type primitive) {
        return PRIMITIVES_TO_BOXED.getOrDefault(primitive, primitive);
    }

    @NotNull
    public static Type boxedToPrimative(Type boxed) {
        return BOXED_TO_PRIMITIVES.getOrDefault(boxed, boxed);
    }

    public static boolean matches(@NotNull Type type1, @NotNull Type type2) {
        Type t1 = TypeUtility.isPrimitive(type1) ? TypeUtility.primitiveToBoxed(type1) : type1;
        Type t2 = TypeUtility.isPrimitive(type2) ? TypeUtility.primitiveToBoxed(type2) : type2;
        return t1.equals(t2);
    }

    public static Type getInsideGeneric(Type genericType, Type fallback) {
        try {
            return ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        catch (ClassCastException e) {
            return fallback;
        }
    }

    public static Type getComponentType(Type type) {
        final AtomicReference result = new AtomicReference();
        new TypeVisitor(){

            @Override
            protected void visitGenericArrayType(GenericArrayType t) {
                result.set(t.getGenericComponentType());
            }

            @Override
            protected void visitClass(Class<?> t) {
                result.set(t.getComponentType());
            }

            @Override
            protected void visitTypeVariable(TypeVariable<?> t) {
                result.set(this.subtypeOfComponentType(t.getBounds()));
            }

            @Override
            protected void visitWildcardType(WildcardType t) {
                result.set(this.subtypeOfComponentType(t.getUpperBounds()));
            }

            private Type subtypeOfComponentType(Type[] bounds) {
                return bounds.length > 0 ? bounds[0] : null;
            }
        }.visit(type);
        return (Type)result.get();
    }

    static Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static boolean areRelatedTypes(Type type1, Type type2) {
        return TypeUtility.matches(type1, type2) || TypeWrap.of(type1).isSupertypeOf(type2) || TypeWrap.of(type2).isSupertypeOf(type1);
    }

    public static boolean isNumber(String str) {
        return TypeUtility.isDouble(str);
    }
}

