/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.help;

import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.NoHelpPageException;
import dev.velix.imperat.help.HelpTemplate;
import dev.velix.imperat.help.UsageFormatter;
import dev.velix.imperat.util.text.PaginatedText;
import dev.velix.imperat.util.text.TextPage;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0")
public abstract class PaginatedHelpTemplate<S extends Source>
extends HelpTemplate<S> {
    protected final int syntaxesPerPage;
    PaginatedText<CommandUsage<S>> paginatedText;

    public PaginatedHelpTemplate(UsageFormatter formatter, int syntaxesPerPage) {
        super(formatter);
        this.syntaxesPerPage = syntaxesPerPage;
        this.paginatedText = new PaginatedText(syntaxesPerPage);
    }

    @Override
    public void display(ExecutionContext<S> context, Source source, UsageFormatter formatter, Collection<? extends CommandUsage<S>> commandUsages) throws ImperatException {
        Integer page = context.getArgumentOr("page", 1);
        TextPage<CommandUsage<S>> textPage = this.paginatedText.getPage(page);
        if (textPage == null) {
            throw new NoHelpPageException();
        }
        int index = 0;
        for (CommandUsage<S> usage : textPage.asList()) {
            source.reply(formatter.format(context.command(), usage, index));
            ++index;
        }
    }

    @Override
    public void provide(ExecutionContext<S> context, Source source) throws ImperatException {
        Collection commandUsages = context.command().usages();
        commandUsages.forEach(this.paginatedText::add);
        this.paginatedText.paginate();
        super.provide(context, source);
        this.paginatedText.clear();
    }
}

