/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.help;

import dev.velix.imperat.command.Command;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.NoHelpException;
import dev.velix.imperat.help.HelpProvider;
import dev.velix.imperat.help.UsageFormatter;
import org.jetbrains.annotations.ApiStatus;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.AvailableSince(value="1.0.0")
public abstract class HelpTemplate<S extends Source>
implements HelpProvider<S> {
    protected final UsageFormatter formatter;

    public HelpTemplate(UsageFormatter formatter) {
        this.formatter = formatter;
    }

    public abstract String getHeader(Command<S> var1, int var2, int var3);

    public abstract String getFooter(Command<S> var1, int var2, int var3);

    @Override
    public void provide(ExecutionContext<S> context, Source source) throws ImperatException {
        Command command = context.command();
        int maxUsages = command.usages().size();
        if (maxUsages == 0) {
            throw new NoHelpException();
        }
        int page = context.getArgumentOr("page", 1);
        this.displayHeaderHyphen(command, source, page);
        this.display(context, source, this.formatter, command.usages());
        this.displayFooterHyphen(command, source, page);
    }

    public abstract void displayHeaderHyphen(Command<S> var1, Source var2, int var3);

    public abstract void displayFooterHyphen(Command<S> var1, Source var2, int var3);
}

