/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context.internal;

import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.FlagParameter;
import dev.velix.imperat.command.parameters.type.ParameterFlag;
import dev.velix.imperat.command.parameters.type.ParameterTypes;
import dev.velix.imperat.context.Context;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.ResolvedContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandFlag;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.context.internal.CommandInputStreamImpl;
import dev.velix.imperat.context.internal.ShiftTarget;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.supplier.OptionalValueSupplier;
import dev.velix.imperat.util.Patterns;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

final class SmartUsageResolve<S extends Source> {
    private final CommandUsage<S> usage;
    private final ResolvedContext<S> context;
    private final CommandInputStream<S> stream;
    private Command<S> command;

    SmartUsageResolve(Command<S> command, ResolvedContext<S> context, CommandUsage<S> usage) {
        this.command = command;
        this.context = context;
        this.usage = usage;
        this.stream = new CommandInputStreamImpl<S>(context.arguments(), usage);
    }

    public static <S extends Source> SmartUsageResolve<S> create(Command<S> command, ResolvedContext<S> context, CommandUsage<S> usage) {
        return new SmartUsageResolve<S>(command, context, usage);
    }

    private void handleEmptyOptional(CommandParameter<S> optionalEmptyParameter) throws ImperatException {
        if (optionalEmptyParameter.isFlag()) {
            FlagParameter<S> flagParameter = optionalEmptyParameter.asFlagParameter();
            FlagData<S> flag = flagParameter.flagData();
            Boolean value = flag.isSwitch() ? Boolean.valueOf(false) : flagParameter.getDefaultValueSupplier().supply(this.context.source());
            this.context.resolveFlag(flag, null, null, value);
        } else {
            this.context.resolveArgument(this.command, null, this.stream.cursor().parameter, optionalEmptyParameter, this.getDefaultValue(this.context, optionalEmptyParameter));
        }
    }

    public void resolve() throws ImperatException {
        String currentRaw;
        CommandParameter currentParameter;
        int lengthWithoutFlags = this.usage.getParametersWithoutFlags().size();
        while (this.stream.hasNextParameter() && (currentParameter = (CommandParameter)this.stream.currentParameter().orElse(null)) != null) {
            ParameterFlag<S> parameterFlag;
            currentRaw = this.stream.currentRaw().orElse(null);
            if (currentRaw == null) {
                CommandParameter param;
                if (currentParameter.isOptional()) {
                    this.handleEmptyOptional(currentParameter);
                }
                while (this.stream.hasNextParameter() && (param = (CommandParameter)this.stream.popParameter().filter(CommandParameter::isOptional).orElse(null)) != null) {
                    this.handleEmptyOptional(param);
                }
                break;
            }
            if (currentParameter.isCommand()) {
                Command parameterSubCmd = (Command)currentParameter;
                if (!parameterSubCmd.hasName(currentRaw)) {
                    throw new SourceException("Unknown sub-command '" + currentRaw + "'", new Object[0]);
                }
                this.command = parameterSubCmd;
                this.stream.skip();
                continue;
            }
            FlagData<S> flag = this.usage.getFlagParameterFromRaw(currentRaw);
            if (currentParameter.isFlag()) {
                assert (currentParameter.isFlag());
                if (flag == null) {
                    throw new SourceException("Unknown flag '%s'", currentRaw);
                }
                parameterFlag = (ParameterFlag<S>)currentParameter.asFlagParameter().type();
                this.context.resolveFlag((CommandFlag)parameterFlag.resolve((ExecutionContext)this.context, (CommandInputStream)this.stream));
                this.stream.skip();
                continue;
            }
            if (Patterns.isInputFlag(currentRaw) && this.command.getFlagFromRaw(currentRaw).isPresent()) {
                parameterFlag = ParameterTypes.flag();
                this.context.resolveFlag(parameterFlag.resolveFreeFlag(this.context, this.stream, this.command.getFlagFromRaw(currentRaw).get()));
                this.stream.skipRaw();
                continue;
            }
            Object value = currentParameter.type().resolve(this.context, this.stream);
            if (value instanceof CommandFlag) {
                CommandFlag commandFlag = (CommandFlag)value;
                this.context.resolveFlag(commandFlag);
                this.stream.skip();
                continue;
            }
            if (currentParameter.isOptional()) {
                this.resolveOptional(currentRaw, currentParameter, lengthWithoutFlags, value);
                continue;
            }
            this.resolveRequired(currentRaw, currentParameter, value);
        }
        CommandParameter<S> lastParam = this.usage.getParameter(this.usage.size() - 1);
        while (this.stream.hasNextRaw() && (lastParam == null || !lastParam.isGreedy()) && (currentRaw = (String)this.stream.currentRaw().orElse(null)) != null) {
            Optional freeFlagData = this.command.getFlagFromRaw(currentRaw);
            if (Patterns.isInputFlag(currentRaw) && freeFlagData.isPresent()) {
                FlagData freeFlag = freeFlagData.get();
                CommandFlag value = ParameterTypes.flag().resolveFreeFlag(this.context, this.stream, freeFlag);
                this.context.resolveFlag(value);
            }
            this.stream.skipRaw();
        }
    }

    private void resolveRequired(String currentRaw, CommandParameter<S> currentParameter, Object resolveResult) throws ImperatException {
        this.context.resolveArgument(this.command, currentRaw, this.stream.currentParameterPosition(), currentParameter, resolveResult);
        this.stream.skip();
    }

    private void resolveOptional(String currentRaw, CommandParameter<S> currentParameter, int lengthWithoutFlags, Object resolveResult) throws ImperatException {
        int currentParameterPosition = this.stream.currentParameterPosition();
        if (this.stream.rawsLength() < lengthWithoutFlags) {
            int diff = lengthWithoutFlags - this.stream.rawsLength();
            if (!this.stream.cursor().isLast(ShiftTarget.PARAMETER_ONLY)) {
                if (diff > 1) {
                    CommandParameter nextParam = this.stream.peekParameter().filter(CommandParameter::isRequired).orElse(null);
                    if (nextParam == null) {
                        this.stream.skipParameter();
                        return;
                    }
                    this.context.resolveArgument(this.command, currentRaw, currentParameterPosition, currentParameter, this.getDefaultValue(this.context, currentParameter));
                    this.context.resolveArgument(this.command, currentRaw, currentParameterPosition + 1, nextParam, resolveResult);
                    this.stream.skipParameter();
                } else {
                    this.context.resolveArgument(this.command, currentRaw, currentParameterPosition, currentParameter, resolveResult);
                    this.stream.skip();
                }
            } else {
                this.context.resolveArgument(this.command, currentRaw, currentParameterPosition, currentParameter, this.getDefaultValue(this.context, currentParameter));
                this.stream.skipParameter();
            }
            return;
        }
        this.context.resolveArgument(this.command, currentRaw, currentParameterPosition, currentParameter, resolveResult);
        this.stream.skip();
    }

    @Nullable
    private <T> T getDefaultValue(Context<S> context, CommandParameter<S> parameter) {
        OptionalValueSupplier optionalSupplier = parameter.getDefaultValueSupplier();
        return optionalSupplier.supply(context.source());
    }

    public Command<S> getCommand() {
        return this.command;
    }
}

