/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context.internal;

import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.NumericParameter;
import dev.velix.imperat.command.parameters.NumericRange;
import dev.velix.imperat.context.Context;
import dev.velix.imperat.context.ResolvedContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.Argument;
import dev.velix.imperat.context.internal.CommandFlag;
import dev.velix.imperat.context.internal.ContextImpl;
import dev.velix.imperat.context.internal.SmartUsageResolve;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.NumberOutOfRangeException;
import dev.velix.imperat.resolvers.ContextResolver;
import dev.velix.imperat.resolvers.SourceResolver;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.Registry;
import dev.velix.imperat.util.TypeUtility;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class ResolvedContextImpl<S extends Source>
extends ContextImpl<S>
implements ResolvedContext<S> {
    private final CommandUsage<S> usage;
    private final Registry<String, CommandFlag> flagRegistry = new Registry();
    private final Registry<Command<S>, Registry<String, Argument<S>>> resolvedArgumentsPerCommand = new Registry(LinkedHashMap::new);
    private final Registry<String, Argument<S>> allResolvedArgs = new Registry(LinkedHashMap::new);
    private Command<S> lastCommand;

    ResolvedContextImpl(ImperatConfig<S> dispatcher, Context<S> context, CommandUsage<S> usage) {
        super(dispatcher, context.command(), context.source(), context.arguments());
        this.lastCommand = context.command();
        this.usage = usage;
    }

    @Override
    @Nullable
    public Argument<S> getResolvedArgument(Command<S> command, String name) {
        return this.resolvedArgumentsPerCommand.getData(command).flatMap(resolvedArgs -> resolvedArgs.getData(name)).orElse(null);
    }

    @Override
    public List<Argument<S>> getResolvedArguments(Command<S> command) {
        return this.resolvedArgumentsPerCommand.getData(command).map(argMap -> new ArrayList(argMap.getAll())).orElse(Collections.emptyList());
    }

    @Override
    @NotNull
    public Iterable<? extends Command<S>> getCommandsUsed() {
        return this.resolvedArgumentsPerCommand.getKeys();
    }

    @Override
    public Collection<? extends Argument<S>> getResolvedArguments() {
        return this.allResolvedArgs.getAll();
    }

    @Override
    @Nullable
    public <T> T getArgument(String name) {
        return this.allResolvedArgs.getData(name).map(Argument::value).orElse(null);
    }

    @Override
    @NotNull
    public <R> R getResolvedSource(Type type) throws ImperatException {
        if (!this.dispatcher.hasSourceResolver(type)) {
            throw new IllegalArgumentException("Found no SourceResolver for valueType `" + type.getTypeName() + "`");
        }
        SourceResolver sourceResolver = this.dispatcher.getSourceResolver(type);
        assert (sourceResolver != null);
        return sourceResolver.resolve(this.source());
    }

    @Override
    @Nullable
    public <T> T getContextResolvedArgument(Class<T> type) throws ImperatException {
        ContextResolver resolver = this.dispatcher.getContextResolver(type);
        return resolver == null ? null : (T)resolver.resolve(this, null);
    }

    @Override
    public Collection<? extends CommandFlag> getResolvedFlags() {
        return this.flagRegistry.getAll();
    }

    @Override
    public Optional<CommandFlag> getFlag(String flagName) {
        return this.flagRegistry.getData(flagName);
    }

    @Override
    @Nullable
    public <T> T getFlagValue(String flagName) {
        return this.getFlag(flagName).map(CommandFlag::value).orElse(null);
    }

    @Override
    public void resolve() throws ImperatException {
        if (this.arguments().isEmpty()) {
            return;
        }
        SmartUsageResolve sur = SmartUsageResolve.create(this.command(), this, this.usage);
        sur.resolve();
        this.lastCommand = sur.getCommand();
    }

    @Override
    public <T> void resolveArgument(Command<S> command, @Nullable String raw, int index, CommandParameter<S> parameter, @Nullable T value) throws ImperatException {
        NumericParameter numericParameter;
        if (value != null && TypeUtility.isNumericType(value.getClass()) && parameter instanceof NumericParameter && (numericParameter = (NumericParameter)parameter).hasRange() && !numericParameter.matchesRange((Number)value)) {
            NumericRange range = numericParameter.getRange();
            throw new NumberOutOfRangeException(numericParameter, (Number)value, range);
        }
        Argument argument = new Argument(raw, parameter, index, value);
        this.resolvedArgumentsPerCommand.update(command, existingResolvedArgs -> {
            if (existingResolvedArgs != null) {
                return existingResolvedArgs.setData(parameter.name(), argument);
            }
            return new Registry<String, Argument>(parameter.name(), argument, LinkedHashMap::new);
        });
        this.allResolvedArgs.setData(parameter.name(), argument);
    }

    @Override
    public void resolveFlag(CommandFlag flag) {
        this.flagRegistry.setData(flag.flag().name(), flag);
    }

    @Override
    @NotNull
    public Command<S> getLastUsedCommand() {
        return this.lastCommand;
    }

    @Override
    public CommandUsage<S> getDetectedUsage() {
        return this.usage;
    }

    @Override
    public void debug() {
        for (Argument<S> arg : this.allResolvedArgs.getAll()) {
            ImperatDebugger.debug("Argument '%s' at index #%s with input='%s' with value='%s'", arg.parameter().format(), arg.index(), arg.raw(), arg.value());
        }
    }
}

