/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context.internal;

import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.context.ArgumentQueue;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.context.internal.Cursor;
import dev.velix.imperat.context.internal.ShiftOperation;
import dev.velix.imperat.context.internal.ShiftTarget;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

final class CommandInputStreamImpl<S extends Source>
implements CommandInputStream<S> {
    private static final char WHITE_SPACE = ' ';
    private int letterPos = 0;
    private final String inputLine;
    private final Cursor<S> cursor;
    private final ArgumentQueue queue;
    private final CommandUsage<S> usage;

    CommandInputStreamImpl(ArgumentQueue queue, CommandUsage<S> usage) {
        this.queue = queue;
        this.inputLine = queue.getOriginalRaw();
        this.usage = usage;
        this.cursor = new Cursor(this, 0, 0);
    }

    @Override
    @NotNull
    public Cursor<S> cursor() {
        return this.cursor;
    }

    @Override
    @NotNull
    public Optional<CommandParameter<S>> currentParameter() {
        return Optional.ofNullable(this.usage.getParameter(this.cursor.parameter));
    }

    @Override
    public Optional<CommandParameter<S>> peekParameter() {
        return Optional.ofNullable(this.usage.getParameter(this.cursor.parameter + 1));
    }

    @Override
    public Optional<CommandParameter<S>> popParameter() {
        this.cursor.shift(ShiftTarget.PARAMETER_ONLY, ShiftOperation.RIGHT);
        return this.currentParameter();
    }

    @Override
    @NotNull
    public Optional<String> currentRaw() {
        if (this.cursor.raw >= this.queue.size()) {
            return Optional.empty();
        }
        return Optional.of((String)this.queue.get(this.cursor.raw));
    }

    @Override
    @NotNull
    public Optional<Character> currentLetter() {
        if (this.letterPos >= this.inputLine.length()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(this.inputLine.charAt(this.letterPos)));
    }

    @Override
    public Optional<Character> peekLetter() {
        int nextLetterPos = this.letterPos + 1;
        if (nextLetterPos >= this.inputLine.length()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(this.inputLine.charAt(nextLetterPos)));
    }

    @Override
    public Optional<Character> popLetter() {
        ++this.letterPos;
        return this.currentLetter();
    }

    @Override
    public Optional<String> peekRaw() {
        int next = this.cursor.raw + 1;
        return Optional.ofNullable(this.queue.getOr(next, null));
    }

    @Override
    public Optional<String> popRaw() {
        this.cursor.shift(ShiftTarget.RAW_ONLY, ShiftOperation.RIGHT);
        return this.currentRaw().stream().peek(raw -> this.letterPos += raw.length() + 1).findFirst();
    }

    @Override
    public boolean hasNextLetter() {
        return this.letterPos < this.inputLine.length();
    }

    @Override
    public boolean hasNextRaw() {
        return this.cursor.raw < this.queue.size();
    }

    @Override
    public boolean hasNextParameter() {
        return this.cursor.parameter < this.usage.size();
    }

    @Override
    @NotNull
    public ArgumentQueue getRawQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public CommandUsage<S> getUsage() {
        return this.usage;
    }

    @Override
    public boolean skip() {
        Cursor<S> cursor = this.cursor();
        int prevRaw = cursor.raw;
        cursor.shift(ShiftTarget.ALL, ShiftOperation.RIGHT);
        String currentRaw = this.currentRaw().orElse(null);
        if (currentRaw == null) {
            return false;
        }
        int diff = this.inputLine.indexOf(32, this.letterPos) + 1 - this.letterPos;
        this.letterPos += diff;
        return cursor.raw > prevRaw;
    }

    @Override
    public boolean skipLetter() {
        return this.popLetter().isPresent();
    }
}

