/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context;

import dev.velix.imperat.command.parameters.type.ParameterEnum;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.command.parameters.type.ParameterTypes;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandFlag;
import dev.velix.imperat.util.Registry;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ParamTypeRegistry<S extends Source>
extends Registry<Type, ParameterType<S, ?>> {
    private ParamTypeRegistry() {
        this.registerResolver((Type)((Object)Boolean.class), ParameterTypes.bool());
        this.registerResolver((Type)((Object)String.class), ParameterTypes.string());
        this.registerResolver((Type)((Object)UUID.class), ParameterTypes.uuid());
        this.registerResolver((Type)((Object)CommandFlag.class), ParameterTypes.flag());
    }

    public static <S extends Source> ParamTypeRegistry<S> createDefault() {
        return new ParamTypeRegistry<S>();
    }

    public <T> void registerResolver(Type type, ParameterType<S, T> resolver) {
        if (TypeUtility.areRelatedTypes(type, Enum.class)) {
            return;
        }
        this.setData(type, resolver);
    }

    public Optional<ParameterType<S, ?>> getResolver(Type type) {
        if (TypeUtility.isNumericType(TypeWrap.of(type))) {
            return Optional.of(ParameterTypes.numeric((Class)type));
        }
        return Optional.ofNullable(this.getData(TypeUtility.primitiveToBoxed(type)).orElseGet(() -> {
            if (TypeUtility.areRelatedTypes(type, Enum.class)) {
                ParameterEnum preloadedEnumType = new ParameterEnum(TypeWrap.of(type));
                this.registerResolver(type, preloadedEnumType);
                return preloadedEnumType;
            }
            for (Type registeredType : this.getKeys()) {
                if (!TypeUtility.areRelatedTypes(type, registeredType)) continue;
                return this.getData(registeredType).orElse(null);
            }
            return null;
        }));
    }
}

