/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context;

import dev.velix.imperat.context.ArgumentQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.Internal
final class ArgumentQueueImpl
extends LinkedList<String>
implements ArgumentQueue {
    private final String originalRaw;
    private final List<String> unmodifiableView;

    ArgumentQueueImpl(String originalRaw, @NotNull Collection<? extends String> input) {
        super(input);
        this.originalRaw = originalRaw;
        this.unmodifiableView = Collections.unmodifiableList(this);
    }

    public ArgumentQueueImpl(String originalRaw, String ... rawArgs) {
        this.originalRaw = originalRaw;
        Collections.addAll(this, rawArgs);
        this.unmodifiableView = Collections.unmodifiableList(this);
    }

    @Override
    public String getOriginalRaw() {
        return this.originalRaw;
    }

    @Override
    @NotNull
    public String join(String delimiter) {
        return String.join((CharSequence)delimiter, this);
    }

    @Override
    @NotNull
    public String join(@NotNull String delimiter, int startIndex) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (int i = startIndex; i < this.size(); ++i) {
            joiner.add((CharSequence)this.get(i));
        }
        return joiner.toString();
    }

    @Override
    @NotNull
    public @UnmodifiableView List<String> asImmutableView() {
        return this.unmodifiableView;
    }

    @Override
    @NotNull
    public @Unmodifiable List<String> asImmutableCopy() {
        return Collections.unmodifiableList(new LinkedList<String>(this));
    }

    @Override
    @NotNull
    public ArgumentQueue copy() {
        return new ArgumentQueueImpl(this.originalRaw, this);
    }
}

