/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.tree;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.suggestions.CompletionArg;
import dev.velix.imperat.command.tree.ArgumentNode;
import dev.velix.imperat.command.tree.CommandDispatch;
import dev.velix.imperat.command.tree.CommandNode;
import dev.velix.imperat.command.tree.ParameterNode;
import dev.velix.imperat.context.ArgumentQueue;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.SuggestionContext;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.Patterns;
import dev.velix.imperat.util.TypeUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandTree<S extends Source> {
    final Command<S> rootCommand;
    final CommandNode<S> root;

    CommandTree(Command<S> command) {
        this.rootCommand = command;
        this.root = new CommandNode<S>(command);
    }

    public static <S extends Source> CommandTree<S> create(Command<S> command) {
        return new CommandTree<S>(command);
    }

    public static <S extends Source> CommandTree<S> parsed(Command<S> command) {
        CommandTree<S> tree = CommandTree.create(command);
        tree.parseCommandUsages();
        return tree;
    }

    public void parseCommandUsages() {
        for (CommandUsage usage : ((Command)this.root.data).usages()) {
            this.parseUsage(usage);
        }
    }

    public void parseUsage(CommandUsage<S> usage) {
        for (FlagData<S> flag : usage.getUsedFreeFlags()) {
            this.rootCommand.registerFlag(flag);
        }
        List<CommandParameter<S>> parameters = usage.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        this.addParametersToTree(this.root, parameters, 0);
    }

    private void addParametersToTree(ParameterNode<S, ?> currentNode, List<CommandParameter<S>> parameters, int index) {
        if (index >= parameters.size()) {
            return;
        }
        CommandParameter<S> param = parameters.get(index);
        ParameterNode<S, ?> childNode = this.getChildNode(currentNode, param);
        this.addParametersToTree(childNode, parameters, index + 1);
    }

    private ParameterNode<S, ?> getChildNode(ParameterNode<S, ?> parent, CommandParameter<S> param) {
        for (ParameterNode<S, ?> child : parent.getChildren()) {
            if (!child.data.name().equalsIgnoreCase(param.name()) || !TypeUtility.matches(child.data.valueType(), param.valueType())) continue;
            return child;
        }
        ParameterNode newNode = param.isCommand() ? new CommandNode<S>(param.asCommand()) : new ArgumentNode<S>(param);
        parent.addChild(newNode);
        return newNode;
    }

    @NotNull
    public CompletableFuture<Collection<String>> tabComplete(Imperat<S> imperat, SuggestionContext<S> context) {
        ParameterNode child2;
        String raw;
        int depthToReach = context.getArgToComplete().index();
        Object source = context.source();
        ParameterNode node = this.root;
        for (int i = 0; i < depthToReach && (raw = context.arguments().getOr(i, null)) != null && (child2 = node.getChild(c -> {
            boolean hasPerm = ((Command)this.root.data).isIgnoringACPerms() || imperat.config().getPermissionResolver().hasPermission((Source)source, c.data.permission());
            boolean matches = c.matchesInput(raw);
            return hasPerm && matches;
        })) != null; ++i) {
            node = child2;
        }
        CompletionStage<Collection<String>> future = CompletableFuture.completedFuture(new ArrayList());
        for (ParameterNode child2 : node.getChildren()) {
            future = future.thenCompose(results -> this.addChildResults(imperat, context, child2, (Collection<String>)results));
        }
        return future;
    }

    private CompletableFuture<Collection<String>> addChildResults(Imperat<S> imperat, SuggestionContext<S> context, ParameterNode<S, ?> node, Collection<String> oldResults) {
        SuggestionResolver<S> resolver = imperat.config().getParameterSuggestionResolver((CommandParameter<S>)node.data);
        return ((CompletableFuture)resolver.asyncAutoComplete(context, (CommandParameter<S>)node.data).thenApply(results -> {
            ArrayList<String> data = new ArrayList<String>((Collection<String>)results);
            data.removeIf(entry -> !node.matchesInput((String)entry));
            return data;
        })).thenApply(res -> {
            oldResults.addAll((Collection<String>)res);
            CompletionArg toComplete = context.getArgToComplete();
            if (!toComplete.isEmpty()) {
                String input = context.getArgToComplete().value();
                return new ArrayList<String>(oldResults.stream().sorted(Comparator.comparingInt(str -> str.toLowerCase().startsWith(input) ? 0 : 1).thenComparingInt(str -> str.toLowerCase().contains(input) ? 0 : 1).thenComparing(String.CASE_INSENSITIVE_ORDER)).toList());
            }
            return oldResults;
        });
    }

    @NotNull
    public CommandDispatch<S> contextMatch(ArgumentQueue input) {
        if (input.isEmpty()) {
            return CommandDispatch.incomplete();
        }
        int depth = 0;
        for (ParameterNode child : this.root.getChildren()) {
            CommandDispatch nodeTraversing = CommandDispatch.unknown();
            CommandDispatch traverse = this.dispatchNode(nodeTraversing, input, child, depth);
            if (traverse.result() == CommandDispatch.Result.UNKNOWN) continue;
            return traverse;
        }
        return CommandDispatch.unknown();
    }

    @NotNull
    private CommandDispatch<S> dispatchNode(CommandDispatch<S> commandDispatch, ArgumentQueue input, ParameterNode<S, ?> currentNode, int depth) {
        if (depth >= input.size()) {
            return commandDispatch;
        }
        String rawInput = (String)input.get(depth);
        ImperatDebugger.debug("Current depth=%s, node=%s", depth, currentNode.format());
        if (!currentNode.matchesInput(rawInput)) {
            ImperatDebugger.debug("Node '%s' doesn't match input '%s'", currentNode.format(), input.get(depth));
            return commandDispatch;
        }
        if (!currentNode.isFlag() && Patterns.isInputFlag(rawInput)) {
            Optional flagData = this.rootCommand.getFlagFromRaw(rawInput);
            if (flagData.isEmpty()) {
                return commandDispatch;
            }
            FlagData flag = flagData.get();
            int depthIncrease = flag.isSwitch() ? 1 : 2;
            return this.dispatchNode(commandDispatch, input, currentNode, depth + depthIncrease);
        }
        ImperatDebugger.debug("Appending node=%s, at depth=%s", currentNode.format(), depth);
        commandDispatch.append(currentNode);
        if (!currentNode.isLast()) {
            if (this.isLastDepth(depth, input)) {
                ImperatDebugger.debug("Reached the end of the input at depth=%s", depth);
                if (currentNode.isCommand()) {
                    ImperatDebugger.debug("The last node at last depth is command=%s", currentNode.format());
                    this.addOptionalChildren(commandDispatch, currentNode);
                    commandDispatch.result(CommandDispatch.Result.INCOMPLETE);
                    return commandDispatch;
                }
                ImperatDebugger.debug("Finding missing required argument", new Object[0]);
                ParameterNode<S, ?> requiredParameterNode = this.findRequiredNodeDeeply(currentNode);
                if (requiredParameterNode == null) {
                    ImperatDebugger.debug("No missing required args, it's complete now", new Object[0]);
                    commandDispatch.result(CommandDispatch.Result.COMPLETE);
                    this.addOptionalChildren(commandDispatch, currentNode);
                } else {
                    ImperatDebugger.debug("There are missing required args !!, the usage is UNKNOWN", new Object[0]);
                    commandDispatch.result(requiredParameterNode.isCommand() ? CommandDispatch.Result.COMPLETE : CommandDispatch.Result.UNKNOWN);
                }
            } else {
                ImperatDebugger.debug("we still in the middle of the input at depth=%s", depth);
                for (ParameterNode<S, ?> child : currentNode.getChildren()) {
                    CommandDispatch<S> result = this.dispatchNode(commandDispatch, input, child, depth + 1);
                    if (result.result() != CommandDispatch.Result.COMPLETE) continue;
                    return result;
                }
            }
        } else {
            ImperatDebugger.debug("We reached the end of the node, at node=%s", currentNode.format());
            if (this.isLastDepth(depth, input)) {
                commandDispatch.result(CommandDispatch.Result.COMPLETE);
            } else {
                String nextRaw = input.getOr(depth + 1, null);
                assert (nextRaw != null);
                ImperatDebugger.debug("nextRaw=%s, at depth=%s, max-depth=%s", nextRaw, depth + 1, input.size() - 1);
                ImperatDebugger.debug("isInputFlag-nextRaw='%s',  isFreeFlagRegisteredToCommand='%s'", Patterns.isInputFlag(nextRaw), this.rootCommand.getFlagFromRaw(nextRaw).isPresent());
                CommandDispatch.Result result = currentNode.isTrueFlag() && this.isLastDepth(depth + 1, input) ? CommandDispatch.Result.COMPLETE : (Patterns.isInputFlag(nextRaw) && this.rootCommand.getFlagFromRaw(nextRaw).isPresent() ? CommandDispatch.Result.COMPLETE : (!currentNode.isGreedyParam() ? CommandDispatch.Result.UNKNOWN : CommandDispatch.Result.COMPLETE));
                commandDispatch.result(result);
            }
        }
        return commandDispatch;
    }

    @Nullable
    private ParameterNode<S, ?> findRequiredNodeDeeply(ParameterNode<S, ?> currentNode) {
        for (ParameterNode<S, ?> child : currentNode.getChildren()) {
            if (child.isRequired()) {
                return child;
            }
            ParameterNode<S, ?> deepReq = this.findRequiredNodeDeeply(child);
            if (deepReq == null) continue;
            return deepReq;
        }
        return null;
    }

    private void addOptionalChildren(CommandDispatch<S> dispatch, ParameterNode<S, ?> currentNode) {
        ParameterNode<S, ?> childOptional = currentNode.getChild(ParameterNode::isOptional);
        if (childOptional == null) {
            return;
        }
        dispatch.append(childOptional);
        if (!childOptional.isLast()) {
            this.addOptionalChildren(dispatch, childOptional);
        }
    }

    private boolean isLastDepth(int index, ArgumentQueue input) {
        return index == input.size() - 1;
    }

    public CommandNode<S> getRoot() {
        return this.root;
    }
}

