/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.suggestions;

import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.FlagParameter;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.command.suggestions.CompletionArg;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.SuggestionContext;
import dev.velix.imperat.resolvers.SuggestionResolver;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SuggestionResolverRegistry<S extends Source> {
    private final Map<String, SuggestionResolver<S>> resolversPerName;
    private final EnumSuggestionResolver enumSuggestionResolver = new EnumSuggestionResolver();
    private final FlagSuggestionResolver flagSuggestionResolver = new FlagSuggestionResolver();
    private final ImperatConfig<S> imperat;

    private SuggestionResolverRegistry(ImperatConfig<S> imperat) {
        this.imperat = imperat;
        this.resolversPerName = new HashMap<String, SuggestionResolver<S>>();
    }

    public static <S extends Source> SuggestionResolverRegistry<S> createDefault(ImperatConfig<S> imperat) {
        return new SuggestionResolverRegistry<S>(imperat);
    }

    public FlagSuggestionResolver getFlagSuggestionResolver() {
        return this.flagSuggestionResolver;
    }

    public EnumSuggestionResolver getEnumSuggestionResolver() {
        return this.enumSuggestionResolver;
    }

    public void registerNamedResolver(String name, SuggestionResolver<S> suggestionResolver) {
        this.resolversPerName.put(name, suggestionResolver);
    }

    @Nullable
    public SuggestionResolver<S> getResolverByName(String name) {
        return this.resolversPerName.get(name);
    }

    public final class EnumSuggestionResolver
    implements SuggestionResolver<S> {
        private final Map<Type, List<String>> PRE_LOADED_ENUMS = new HashMap<Type, List<String>>();

        public void registerEnumResolver(Type raw) {
            Class enumClass = (Class)raw;
            this.PRE_LOADED_ENUMS.computeIfAbsent(raw, v -> Arrays.stream((Enum[])enumClass.getEnumConstants()).map(Enum::name).toList());
        }

        private Optional<List<String>> getResults(Type type) {
            return Optional.ofNullable(this.PRE_LOADED_ENUMS.get(type));
        }

        public List<String> autoComplete(SuggestionContext<S> context, CommandParameter<S> parameter) {
            Type type = parameter.valueType();
            return this.getResults(type).orElseGet(() -> {
                this.registerEnumResolver(type);
                return this.getResults(type).orElse(Collections.emptyList());
            });
        }
    }

    public final class FlagSuggestionResolver
    implements SuggestionResolver<S> {
        @Override
        public Collection<String> autoComplete(SuggestionContext<S> context, CommandParameter<S> parameter) {
            assert (parameter.isFlag());
            FlagParameter flagParameter = parameter.asFlagParameter();
            CompletionArg arg = context.getArgToComplete();
            FlagData data = flagParameter.flagData();
            if (flagParameter.isSwitch()) {
                return this.autoCompleteFlagNames(data);
            }
            int paramPos = parameter.position();
            int argPos = arg.index();
            if (argPos > paramPos) {
                SuggestionResolver flagInputResolver;
                ParameterType inputType = SuggestionResolverRegistry.this.imperat.getParameterType(data.inputType().type());
                SuggestionResolver suggestionResolver = flagInputResolver = inputType == null ? null : inputType.getSuggestionResolver();
                if (flagInputResolver == null) {
                    flagInputResolver = flagParameter.inputSuggestionResolver();
                }
                if (flagInputResolver == null) {
                    return List.of();
                }
                return flagInputResolver.autoComplete(context, parameter);
            }
            return this.autoCompleteFlagNames(data);
        }

        private List<String> autoCompleteFlagNames(FlagData data) {
            ArrayList<String> results = new ArrayList<String>();
            results.add("-" + data.name());
            for (String alias : data.aliases()) {
                results.add("-" + String.valueOf(alias));
            }
            return results;
        }
    }
}

