/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.suggestions;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.suggestions.CompletionArg;
import dev.velix.imperat.command.suggestions.NativeAutoCompleter;
import dev.velix.imperat.context.ArgumentQueue;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.SuggestionContext;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.AvailableSince(value="1.0.0")
public abstract class AutoCompleter<S extends Source> {
    protected final Command<S> command;

    protected AutoCompleter(Command<S> command) {
        this.command = command;
    }

    public static <S extends Source> AutoCompleter<S> createNative(Command<S> command) {
        return new NativeAutoCompleter<S>(command);
    }

    @NotNull
    private static CompletionArg getLastArg(String[] args) {
        if (args.length == 0) {
            return new CompletionArg("", -1);
        }
        int index = args.length - 1;
        String result = args[args.length - 1];
        return new CompletionArg(result, index);
    }

    public final CompletableFuture<Collection<String>> autoComplete(Imperat<S> dispatcher, S sender, String[] args) {
        CompletionArg argToComplete = AutoCompleter.getLastArg(args);
        ArgumentQueue queue = ArgumentQueue.parseAutoCompletion(args, argToComplete.isEmpty());
        SuggestionContext context = dispatcher.config().getContextFactory().createSuggestionContext(sender, this.command, queue, argToComplete);
        return this.autoComplete(dispatcher, context).exceptionally(ex -> {
            dispatcher.config().handleThrowable((Throwable)ex, context, AutoCompleter.class, "autoComplete(dispatcher, sender, args)");
            return Collections.emptyList();
        });
    }

    public abstract CompletableFuture<Collection<String>> autoComplete(Imperat<S> var1, SuggestionContext<S> var2);
}

