/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Type;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class ParameterEnum<S extends Source>
extends BaseParameterType<S, Enum<?>> {
    public ParameterEnum(TypeWrap<Enum<?>> typeWrap) {
        super(typeWrap);
        Class type = (Class)typeWrap.getType();
        for (Enum constantEnum : (Enum[])type.getEnumConstants()) {
            this.suggestions.add(constantEnum.name());
        }
    }

    @Override
    @NotNull
    public Enum<?> resolve(ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream) throws ImperatException {
        Type enumType = commandInputStream.currentParameter().filter(param -> TypeUtility.matches(this.type, Enum.class)).map(CommandParameter::valueType).orElse(this.type);
        Optional<String> raw = commandInputStream.currentRaw();
        try {
            assert (raw.isPresent());
            return Enum.valueOf((Class)enumType, raw.get());
        }
        catch (EnumConstantNotPresentException | IllegalArgumentException ex) {
            throw new SourceException("Invalid " + enumType.getTypeName() + " '" + String.valueOf(raw) + "'", new Object[0]);
        }
    }

    @Override
    public boolean matchesInput(String input, CommandParameter<S> parameter) {
        try {
            if (!TypeWrap.of(this.type).isSubtypeOf((Type)((Object)Enum.class))) {
                return true;
            }
            Enum.valueOf((Class)this.type, input);
            return true;
        }
        catch (EnumConstantNotPresentException | IllegalArgumentException ex) {
            return false;
        }
    }

    @Override
    @NotNull
    public Enum<?> fromString(Imperat<S> imperat, String input) {
        return Enum.valueOf((Class)this.type, input);
    }
}

