/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.util.TypeWrap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterBoolean<S extends Source>
extends BaseParameterType<S, Boolean> {
    private static final Map<String, Boolean> VARIANTS = Map.of("t", true, "f", false, "yes", true, "no", false, "y", true, "n", false, "on", true, "off", false, "enabled", true, "disabled", false);
    private boolean allowVariants = false;

    ParameterBoolean() {
        super(TypeWrap.of(Boolean.class));
        this.withSuggestions("true", "false");
    }

    @Override
    @Nullable
    public Boolean resolve(ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream) throws ImperatException {
        String raw = commandInputStream.currentRaw().orElse(null);
        assert (raw != null);
        if (raw.equalsIgnoreCase("true") || raw.equalsIgnoreCase("false")) {
            return Boolean.parseBoolean(raw);
        }
        if (this.allowVariants) {
            return VARIANTS.get(raw.toLowerCase());
        }
        throw new SourceException("Invalid boolean '%s'", raw);
    }

    @Override
    public boolean matchesInput(String input, CommandParameter<S> parameter) {
        if (!this.allowVariants && (input.equalsIgnoreCase("true") || input.equalsIgnoreCase("false"))) {
            return true;
        }
        if (this.allowVariants) {
            return VARIANTS.get(input.toLowerCase(Locale.ENGLISH)) != null;
        }
        return Boolean.parseBoolean(input);
    }

    @Override
    @NotNull
    public Boolean fromString(Imperat<S> imperat, String input) {
        return Boolean.parseBoolean(input);
    }

    public ParameterBoolean<S> setAllowVariants(boolean allowVariants) {
        this.allowVariants = allowVariants;
        if (allowVariants) {
            this.suggestions.addAll(VARIANTS.keySet());
        } else {
            this.suggestions.removeAll(VARIANTS.keySet());
        }
        return this;
    }

    public ParameterBoolean<S> allowVariants() {
        return this.setAllowVariants(true);
    }
}

