/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BaseParameterType<S extends Source, T>
implements ParameterType<S, T> {
    protected final Type type;
    protected final List<String> suggestions = new ArrayList<String>();

    protected BaseParameterType(TypeWrap<T> type) {
        this.type = type.getType();
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public SuggestionResolver<S> getSuggestionResolver() {
        return SuggestionResolver.plain(this.suggestions);
    }

    @Override
    public boolean matchesInput(String input, CommandParameter<S> parameter) {
        return true;
    }

    @Override
    @NotNull
    public ParameterType<S, T> withSuggestions(String ... suggestions) {
        this.suggestions.addAll(List.of(suggestions));
        return this;
    }
}

