/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters;

import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.Description;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.FlagParameter;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.supplier.OptionalValueSupplier;
import dev.velix.imperat.util.TypeWrap;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class InputParameter<S extends Source>
implements CommandParameter<S> {
    protected Command<S> parentCommand;
    protected final String name;
    protected final ParameterType<S, ?> type;
    protected final boolean optional;
    protected final boolean flag;
    protected final boolean greedy;
    protected final OptionalValueSupplier<?> optionalValueSupplier;
    protected final SuggestionResolver<S> suggestionResolver;
    protected String permission;
    protected Description description;
    protected int index;

    protected InputParameter(String name, @NotNull ParameterType<S, ?> type, @Nullable String permission, Description description, boolean optional, boolean flag, boolean greedy, @NotNull OptionalValueSupplier<?> optionalValueSupplier, @Nullable SuggestionResolver<S> suggestionResolver) {
        this.name = name;
        this.type = type;
        this.permission = permission;
        this.description = description;
        this.optional = optional;
        this.flag = flag;
        this.greedy = greedy;
        this.optionalValueSupplier = optionalValueSupplier;
        this.suggestionResolver = suggestionResolver;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public Command<S> parent() {
        return this.parentCommand;
    }

    @Override
    public void parent(@NotNull Command<S> parentCommand) {
        this.parentCommand = parentCommand;
    }

    @Override
    public int position() {
        return this.index;
    }

    @Override
    public void position(int position) {
        this.index = position;
    }

    @Override
    @NotNull
    public ParameterType<S, ?> type() {
        return this.type;
    }

    @Override
    public TypeWrap<?> wrappedType() {
        return this.type.wrappedType();
    }

    @Override
    @Nullable
    public String permission() {
        return this.permission;
    }

    @Override
    public void permission(String permission) {
        this.permission = permission;
    }

    @Override
    @NotNull
    public <T> OptionalValueSupplier<T> getDefaultValueSupplier() {
        return this.optionalValueSupplier;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isFlag() {
        return this.flag;
    }

    @Override
    public FlagParameter<S> asFlagParameter() {
        return (FlagParameter)((Object)this);
    }

    @Override
    public boolean isGreedy() {
        if (this.type.type() != String.class && this.greedy) {
            throw new IllegalStateException(String.format("Usage parameter '%s' cannot be greedy while having value-valueType '%s'", this.name, this.valueType().getTypeName()));
        }
        return this.greedy;
    }

    @Override
    public Command<S> asCommand() {
        throw new UnsupportedOperationException("Non-CommandProcessingChain Parameter cannot be converted into a command parameter");
    }

    @Override
    @Nullable
    public SuggestionResolver<S> getSuggestionResolver() {
        return this.suggestionResolver;
    }

    @Override
    public Description description() {
        return this.description;
    }

    @Override
    public void describe(Description description) {
        this.description = description;
    }

    @Override
    public boolean similarTo(CommandParameter<?> parameter) {
        return this.name.equalsIgnoreCase(parameter.name()) && this.type.isRelatedToType(parameter.wrappedType().getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputParameter)) {
            return false;
        }
        InputParameter that = (InputParameter)o;
        return Objects.equals(this.parentCommand, that.parentCommand) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return this.format();
    }
}

