/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters;

import dev.velix.imperat.command.parameters.FlagCommandParameter;
import dev.velix.imperat.command.parameters.FlagParameter;
import dev.velix.imperat.command.parameters.ParameterBuilder;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.command.parameters.type.ParameterTypes;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandFlag;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.supplier.OptionalValueSupplier;
import java.util.ArrayList;
import java.util.List;

public final class FlagBuilder<S extends Source, T>
extends ParameterBuilder<S, CommandFlag> {
    private final ParameterType<S, T> inputType;
    private final List<String> aliases = new ArrayList<String>();
    private boolean free;
    private OptionalValueSupplier<T> defaultValueSupplier = null;
    private SuggestionResolver<S> suggestionResolver;

    private FlagBuilder(String name, ParameterType<S, T> inputType) {
        super(name, ParameterTypes.flag(), true, false);
        this.inputType = inputType;
    }

    private FlagBuilder(String name) {
        this(name, null);
    }

    public static <S extends Source, T> FlagBuilder<S, T> ofFlag(String name, ParameterType<S, T> inputType) {
        return new FlagBuilder<S, T>(name, inputType);
    }

    public static <S extends Source, T> FlagBuilder<S, T> ofSwitch(String name) {
        return new FlagBuilder<S, T>(name);
    }

    public FlagBuilder<S, T> aliases(List<String> aliases) {
        this.aliases.addAll(aliases);
        return this;
    }

    public FlagBuilder<S, T> aliases(String ... aliases) {
        this.aliases.addAll(List.of(aliases));
        return this;
    }

    public FlagBuilder<S, T> flagDefaultInputValue(OptionalValueSupplier<T> valueSupplier) {
        if (this.inputType == null) {
            throw new IllegalArgumentException("Flag of valueType switches, cannot have a default value supplier !");
        }
        this.defaultValueSupplier = valueSupplier;
        return this;
    }

    public FlagBuilder<S, T> suggestForInputValue(SuggestionResolver<S> suggestionResolver) {
        if (this.inputType == null) {
            throw new IllegalArgumentException("Flag of valueType switches, cannot have a default value supplier !");
        }
        this.suggestionResolver = suggestionResolver;
        return this;
    }

    public FlagBuilder<S, T> setFree(boolean free) {
        this.free = free;
        return this;
    }

    @Override
    public FlagParameter<S> build() {
        FlagData<S> flag = FlagData.create(this.name, this.aliases, this.inputType, this.free);
        if (this.inputType == null) {
            this.defaultValueSupplier = OptionalValueSupplier.of(false);
        }
        return new FlagCommandParameter<S>(flag, this.permission, this.description, this.defaultValueSupplier, this.suggestionResolver);
    }
}

