/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command;

import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.annotations.base.element.ParameterElement;
import dev.velix.imperat.command.ContextResolverFactory;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.help.CommandHelp;
import dev.velix.imperat.resolvers.ContextResolver;
import dev.velix.imperat.util.Registry;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Type;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.AvailableSince(value="1.0.0")
public final class ContextResolverRegistry<S extends Source>
extends Registry<Type, ContextResolver<S, ?>> {
    private final Registry<Type, ContextResolverFactory<S, ?>> factories = new Registry();

    private ContextResolverRegistry(ImperatConfig<S> config) {
        this.registerResolver(TypeWrap.of(CommandHelp.class).getType(), (ctx, param) -> new CommandHelp(config, ctx));
    }

    public static <S extends Source> ContextResolverRegistry<S> createDefault(ImperatConfig<S> imperat) {
        return new ContextResolverRegistry<S>(imperat);
    }

    public <T> void registerResolver(Type type, ContextResolver<S, T> resolver) {
        this.setData(type, resolver);
    }

    public <T> void registerFactory(Type type, ContextResolverFactory<S, T> factory) {
        this.factories.setData(type, factory);
    }

    public Optional<ContextResolverFactory<S, ?>> getFactoryFor(Type type) {
        return this.factories.getData(type);
    }

    @Nullable
    public <T> ContextResolver<S, T> getContextResolver(Type type, @Nullable ParameterElement element) {
        ContextResolverFactory factory = this.getFactoryFor(type).orElse(null);
        if (factory == null) {
            return this.factories.getData(type).map(defaultFactory -> defaultFactory.create(type, element)).orElse(this.getData(type).orElse(null));
        }
        return factory.create(type, element);
    }

    @Nullable
    public <T> ContextResolver<S, T> getResolverWithoutParameterElement(Type type) {
        return this.getContextResolver(type, null);
    }
}

