/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandCoordinator;
import dev.velix.imperat.command.CommandExecution;
import dev.velix.imperat.command.CommandUsageImpl;
import dev.velix.imperat.command.CooldownHolder;
import dev.velix.imperat.command.DescriptionHolder;
import dev.velix.imperat.command.PermissionHolder;
import dev.velix.imperat.command.cooldown.CooldownHandler;
import dev.velix.imperat.command.cooldown.UsageCooldown;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.ParameterBuilder;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CommandUsage<S extends Source>
extends PermissionHolder,
DescriptionHolder,
CooldownHolder {
    public static <S extends Source> String format(Command<S> command, CommandUsage<S> usage) {
        StringBuilder builder = new StringBuilder(command.name()).append(' ');
        int i = 0;
        for (CommandParameter<S> parameter : usage.getParameters()) {
            builder.append(parameter.format());
            if (i != usage.getParameters().size() - 1) {
                builder.append(' ');
            }
            ++i;
        }
        return builder.toString();
    }

    public static <S extends Source> Builder<S> builder() {
        return new Builder();
    }

    public boolean hasFlag(String var1);

    @Nullable
    public FlagData<S> getFlagParameterFromRaw(String var1);

    public void addFlag(CommandParameter<S> var1);

    public void addFlag(FlagData<S> var1);

    public Set<FlagData<S>> getUsedFreeFlags();

    public void addParameters(CommandParameter<S> ... var1);

    public void addParameters(List<CommandParameter<S>> var1);

    public List<CommandParameter<S>> getParameters();

    public List<CommandParameter<S>> getParametersWithoutFlags();

    @Nullable
    public CommandParameter<S> getParameter(int var1);

    @NotNull
    public CommandExecution<S> getExecution();

    default public CommandUsage<S> mergeWithCommand(Command<S> subCommand, CommandUsage<S> usage) {
        ArrayList<CommandParameter<S>> comboParams = new ArrayList<CommandParameter<S>>(this.getParameters());
        comboParams.add(subCommand);
        for (CommandParameter param : usage.getParameters()) {
            if (this.hasParameters((CommandParameter<S> p) -> p.equals(param))) continue;
            comboParams.add(param);
        }
        return CommandUsage.builder().coordinator(usage.getCoordinator()).description(subCommand.description().toString()).cooldown(usage.getCooldown()).parameters(comboParams).execute(usage.getExecution()).build(subCommand, usage.isHelp());
    }

    public boolean hasParamType(Class<?> var1);

    public int getMinLength();

    public int getMaxLength();

    public boolean hasParameters(Predicate<CommandParameter<S>> var1);

    @Nullable
    public CommandParameter<S> getParameter(Predicate<CommandParameter<S>> var1);

    @NotNull
    public CooldownHandler<S> getCooldownHandler();

    public void setCooldownHandler(CooldownHandler<S> var1);

    default public boolean isDefault() {
        return this.getParameters().isEmpty();
    }

    public CommandCoordinator<S> getCoordinator();

    public void setCoordinator(CommandCoordinator<S> var1);

    public void execute(Imperat<S> var1, S var2, ExecutionContext<S> var3);

    public boolean isHelp();

    public boolean hasParameters(List<CommandParameter<S>> var1);

    default public int size() {
        return this.getParameters().size();
    }

    public static class Builder<S extends Source> {
        private final List<CommandParameter<S>> parameters = new ArrayList<CommandParameter<S>>();
        private CommandExecution<S> execution = CommandExecution.empty();
        private String description = "N/A";
        private String permission = null;
        private UsageCooldown cooldown = null;
        private CommandCoordinator<S> commandCoordinator = CommandCoordinator.sync();
        private final Set<FlagData<S>> flags = new HashSet<FlagData<S>>();

        Builder() {
        }

        public Builder<S> coordinator(CommandCoordinator<S> commandCoordinator) {
            this.commandCoordinator = commandCoordinator;
            return this;
        }

        public Builder<S> execute(CommandExecution<S> execution) {
            this.execution = execution;
            return this;
        }

        public Builder<S> permission(String permission) {
            this.permission = permission;
            return this;
        }

        public Builder<S> cooldown(long value, TimeUnit unit) {
            return this.cooldown(value, unit, null);
        }

        public Builder<S> cooldown(long value, TimeUnit unit, @Nullable String permission) {
            this.cooldown = new UsageCooldown(value, unit, permission);
            return this;
        }

        public Builder<S> cooldown(@Nullable UsageCooldown cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder<S> description(String description) {
            if (description != null) {
                this.description = description;
            }
            return this;
        }

        @SafeVarargs
        public final Builder<S> parameters(ParameterBuilder<S, ?> ... builders) {
            return this.parameters(Arrays.stream(builders).map(ParameterBuilder::build).toList());
        }

        @SafeVarargs
        public final Builder<S> parameters(CommandParameter<S> ... params) {
            return this.parameters(List.of(params));
        }

        public Builder<S> parameters(List<CommandParameter<S>> params) {
            for (int i = 0; i < params.size(); ++i) {
                CommandParameter<S> parameter = params.get(i);
                if (!parameter.isCommand()) {
                    parameter.position(i);
                }
                this.parameters.add(parameter);
            }
            return this;
        }

        public Builder<S> registerFlags(Set<FlagData<S>> flags) {
            this.flags.addAll(flags);
            return this;
        }

        public CommandUsage<S> build(@NotNull Command<S> command, boolean help) {
            CommandUsageImpl impl = new CommandUsageImpl(this.execution, help);
            impl.setCoordinator(this.commandCoordinator);
            impl.permission(this.permission);
            impl.describe(this.description);
            impl.setCooldown(this.cooldown);
            impl.addParameters(this.parameters.stream().peek(p -> p.parent(command)).toList());
            this.flags.forEach(impl::addFlag);
            impl.getUsedFreeFlags().forEach(command::registerFlag);
            return impl;
        }

        public CommandUsage<S> build(@NotNull Command<S> command) {
            return this.build(command, false);
        }

        public CommandUsage<S> buildAsHelp(@NotNull Command<S> command) {
            return this.build(command, true);
        }
    }
}

