/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandExecution;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.Description;
import dev.velix.imperat.command.UsageMap;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.FlagParameter;
import dev.velix.imperat.command.processors.CommandPostProcessor;
import dev.velix.imperat.command.processors.CommandPreProcessor;
import dev.velix.imperat.command.suggestions.AutoCompleter;
import dev.velix.imperat.command.tree.CommandDispatch;
import dev.velix.imperat.command.tree.CommandTree;
import dev.velix.imperat.command.tree.CommandTreeVisualizer;
import dev.velix.imperat.context.ArgumentQueue;
import dev.velix.imperat.context.Context;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.ResolvedContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.help.PaginatedHelpTemplate;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.util.ImperatDebugger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.Internal
final class CommandImpl<S extends Source>
implements Command<S> {
    private final String name;
    private final int position;
    private final List<String> aliases = new ArrayList<String>();
    private final Map<String, Command<S>> children = new TreeMap<String, Command<S>>();
    private final UsageMap<S> usages = new UsageMap();
    private final AutoCompleter<S> autoCompleter;
    @Nullable
    private final CommandTree<S> commandTree;
    @NotNull
    private final CommandTreeVisualizer<S> visualizer;
    private String permission = null;
    private Description description = Description.EMPTY;
    private boolean suppressACPermissionChecks = false;
    private CommandUsage<S> mainUsage = null;
    private CommandUsage<S> defaultUsage;
    @Nullable
    private CommandPreProcessor<S> preProcessor;
    @Nullable
    private CommandPostProcessor<S> postProcessor;
    private Command<S> parent;
    private final SuggestionResolver<S> suggestionResolver;
    private final Set<FlagData<S>> freeFlags = new HashSet<FlagData<S>>();

    CommandImpl(String name) {
        this(null, name);
    }

    CommandImpl(@Nullable Command<S> parent, String name) {
        this(parent, 0, name);
    }

    CommandImpl(@Nullable Command<S> parent, int position, String name) {
        this.parent = parent;
        this.position = position;
        this.name = name.toLowerCase();
        this.setDefaultUsageExecution((source, context) -> {});
        this.autoCompleter = AutoCompleter.createNative(this);
        this.commandTree = parent != null ? null : CommandTree.create(this);
        this.visualizer = CommandTreeVisualizer.of(this.commandTree);
        this.suggestionResolver = SuggestionResolver.forCommand(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String permission() {
        return this.permission;
    }

    @Override
    public void permission(@Nullable String permission) {
        this.permission = permission;
    }

    @Override
    @NotNull
    public Description description() {
        return this.description;
    }

    @Override
    public void describe(Description description) {
        this.description = description;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void position(int position) {
        throw new UnsupportedOperationException("You can't modify the position of a command");
    }

    @Override
    @NotNull
    public CommandDispatch<S> contextMatch(Context<S> context) {
        if (this.commandTree != null) {
            ArgumentQueue copy = context.arguments().copy();
            copy.removeIf(String::isBlank);
            return this.commandTree.contextMatch(copy);
        }
        throw new IllegalCallerException("Cannot match a sub command in a root's execution !");
    }

    @Override
    public void visualizeTree() {
        ImperatDebugger.debug("Visualizing %s's tree", this.name);
        this.visualizer.visualize();
    }

    @Override
    public void setPreProcessor(@NotNull CommandPreProcessor<S> preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public void preProcess(@NotNull Imperat<S> api, @NotNull Context<S> context, @NotNull CommandUsage<S> usage) throws ImperatException {
        if (this.preProcessor != null) {
            this.preProcessor.process(api, context, usage);
        }
    }

    @Override
    public void setPostProcessor(@NotNull CommandPostProcessor<S> postProcessor) {
        this.postProcessor = postProcessor;
    }

    @Override
    public void postProcess(@NotNull Imperat<S> api, @NotNull ResolvedContext<S> context, @NotNull CommandUsage<S> usage) throws ImperatException {
        if (this.postProcessor != null) {
            this.postProcessor.process(api, context);
        }
    }

    @Override
    public FlagParameter<S> asFlagParameter() {
        throw new UnsupportedOperationException("A command cannot be treated as a flag !");
    }

    @Override
    @Nullable
    public SuggestionResolver<S> getSuggestionResolver() {
        return this.suggestionResolver;
    }

    @Override
    public boolean similarTo(CommandParameter<?> parameter) {
        return this.name.equalsIgnoreCase(parameter.name());
    }

    @Override
    public @UnmodifiableView List<String> aliases() {
        return this.aliases;
    }

    @Override
    public CommandTree<S> tree() {
        return this.commandTree;
    }

    @Override
    public void addAliases(List<String> aliases) {
        for (String alias : aliases) {
            this.aliases.add(alias.toLowerCase());
        }
    }

    @Override
    @NotNull
    public CommandUsage<S> getDefaultUsage() {
        return this.defaultUsage;
    }

    @Override
    public void setDefaultUsageExecution(CommandExecution<S> execution) {
        this.defaultUsage = CommandUsage.builder().execute(execution).build(this);
    }

    @Override
    public void addUsage(CommandUsage<S> usage) {
        if (usage.isDefault()) {
            return;
        }
        this.usages.put(usage.getParameters(), usage);
        if (this.mainUsage == null && usage.getMaxLength() >= 1 && !usage.hasParamType(Command.class)) {
            this.mainUsage = usage;
        }
        if (this.commandTree != null) {
            this.commandTree.parseUsage(usage);
        }
    }

    @Override
    @Nullable
    public CommandUsage<S> getUsage(List<CommandParameter<S>> parameters) {
        if (parameters.isEmpty()) {
            return this.defaultUsage;
        }
        return (CommandUsage)this.usages.get(parameters);
    }

    @Override
    public Collection<? extends CommandUsage<S>> usages() {
        return this.usages.asSortedSet();
    }

    @Override
    public Collection<? extends CommandUsage<S>> findUsages(Predicate<CommandUsage<S>> predicate) {
        return this.usages.values().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public CommandUsage<S> mainUsage() {
        return Optional.ofNullable(this.mainUsage).orElse(this.defaultUsage);
    }

    @Override
    public AutoCompleter<S> autoCompleter() {
        return this.autoCompleter;
    }

    @Override
    @Nullable
    public Command<S> parent() {
        return this.parent;
    }

    @Override
    public void parent(@NotNull Command<S> parent) {
        this.parent = parent;
    }

    private void registerSubCommand(Command<S> command) {
        this.children.put(command.name(), command);
    }

    @Override
    public void addSubCommand(Command<S> command, boolean attachDirectly) {
        command.parent(this);
        this.registerSubCommand(command);
        CommandUsage<S> prime = attachDirectly ? this.getDefaultUsage() : this.mainUsage();
        CommandUsage<S> combo = prime.mergeWithCommand(command, command.mainUsage());
        this.addUsage(combo);
        for (CommandUsage<S> subUsage : command.usages()) {
            if (subUsage.equals(command.mainUsage())) continue;
            combo = prime.mergeWithCommand(command, subUsage);
            this.addUsage(combo);
        }
    }

    @Override
    public void addSubCommandUsage(String subCommand, List<String> aliases, CommandUsage.Builder<S> usage, boolean attachDirectly) {
        int position;
        if (attachDirectly) {
            position = this.position() + 1;
        } else {
            CommandUsage<S> main = this.mainUsage();
            position = this.position() + (main.getMinLength() == 0 ? 1 : main.getMinLength());
        }
        Command subCmd = Command.create(this, position, subCommand.toLowerCase()).aliases(aliases).usage(usage).build();
        this.addSubCommand(subCmd, attachDirectly);
    }

    @Override
    @Nullable
    public Command<S> getSubCommand(String name) {
        Command<S> sub = this.children.get(name);
        if (sub != null) {
            return sub;
        }
        for (String subsNames : this.children.keySet()) {
            Command<S> other = this.children.get(subsNames);
            if (other.hasName(name)) {
                return other;
            }
            if (!subsNames.startsWith(name)) continue;
            return other;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends Command<S>> getSubCommands() {
        return this.children.values();
    }

    @Override
    public boolean isIgnoringACPerms() {
        return this.suppressACPermissionChecks;
    }

    @Override
    public void ignoreACPermissions(boolean suppress) {
        this.suppressACPermissionChecks = suppress;
    }

    @Override
    public void addHelpCommand(Imperat<S> dispatcher, List<CommandParameter<S>> params, CommandExecution<S> helpExecution) {
        if (params.isEmpty() && dispatcher.config().getHelpProvider() instanceof PaginatedHelpTemplate) {
            params.add(CommandParameter.optionalInt("page").description("help-page").defaultValue(1).build());
        }
        this.addSubCommandUsage("help", CommandUsage.builder().parameters(params).execute(helpExecution), true);
    }

    @Override
    public void registerFlag(FlagData<S> flag) {
        this.freeFlags.add(flag);
    }

    @Override
    public Optional<FlagData<S>> getFlagFromRaw(String raw) {
        return this.freeFlags.stream().filter(data -> data.acceptsInput(raw)).findFirst();
    }

    @Override
    public Set<FlagData<S>> getRegisteredFlags() {
        return this.freeFlags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandImpl)) {
            return false;
        }
        CommandImpl command = (CommandImpl)o;
        return Objects.equals(this.name, command.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

