/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base.element.selector;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.annotations.base.AnnotationParser;
import dev.velix.imperat.annotations.base.element.MethodElement;
import dev.velix.imperat.annotations.base.element.selector.RuleCondition;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Rule<T> {
    @NotNull
    public RuleCondition<T> condition();

    default public boolean test(Imperat imperat, AnnotationParser<?> registry, T variable) {
        return this.condition().test(imperat, registry, variable);
    }

    public void onFailure(AnnotationParser<?> var1, T var2);

    @NotNull
    public Rule<T> and(@Nullable Rule<T> var1);

    @NotNull
    public Rule<T> or(@Nullable Rule<T> var1);

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static Builder<MethodElement> buildForMethod() {
        return new Builder<MethodElement>();
    }

    public static class Builder<T> {
        RuleCondition<T> condition;
        BiConsumer<AnnotationParser<?>, T> runnable;

        Builder() {
        }

        public Builder<T> condition(RuleCondition<T> condition) {
            this.condition = condition;
            return this;
        }

        public Builder<T> failure(BiConsumer<AnnotationParser<?>, T> runnable) {
            this.runnable = runnable;
            return this;
        }

        public Rule<T> build() {
            return new SimpleRule<T>(this.condition, this.runnable);
        }
    }

    public static final class SimpleRule<T>
    implements Rule<T> {
        @NotNull
        private RuleCondition<T> condition;
        @NotNull
        private final BiConsumer<AnnotationParser<?>, T> onFailure;

        public SimpleRule(@NotNull RuleCondition<T> condition, @NotNull BiConsumer<AnnotationParser<?>, T> onFailure) {
            this.condition = condition;
            this.onFailure = onFailure;
        }

        @Override
        public void onFailure(AnnotationParser<?> registry, T variable) {
            this.onFailure.accept(registry, (AnnotationParser<?>)variable);
        }

        @Override
        @NotNull
        public Rule<T> and(@Nullable Rule<T> other) {
            if (other == null) {
                return this;
            }
            this.condition = this.condition.and(other.condition());
            return this;
        }

        @Override
        @NotNull
        public Rule<T> or(@Nullable Rule<T> other) {
            if (other == null) {
                return this;
            }
            this.condition = this.condition.or(other.condition());
            return this;
        }

        @Override
        @NotNull
        public RuleCondition<T> condition() {
            return this.condition;
        }
    }
}

