/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base.element;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.annotations.Async;
import dev.velix.imperat.annotations.Command;
import dev.velix.imperat.annotations.Cooldown;
import dev.velix.imperat.annotations.Default;
import dev.velix.imperat.annotations.DefaultProvider;
import dev.velix.imperat.annotations.Description;
import dev.velix.imperat.annotations.Flag;
import dev.velix.imperat.annotations.Greedy;
import dev.velix.imperat.annotations.Named;
import dev.velix.imperat.annotations.Optional;
import dev.velix.imperat.annotations.Permission;
import dev.velix.imperat.annotations.PostProcessor;
import dev.velix.imperat.annotations.PreProcessor;
import dev.velix.imperat.annotations.Range;
import dev.velix.imperat.annotations.SubCommand;
import dev.velix.imperat.annotations.Suggest;
import dev.velix.imperat.annotations.SuggestionProvider;
import dev.velix.imperat.annotations.Switch;
import dev.velix.imperat.annotations.Usage;
import dev.velix.imperat.annotations.base.AnnotationHelper;
import dev.velix.imperat.annotations.base.AnnotationParser;
import dev.velix.imperat.annotations.base.MethodCommandExecutor;
import dev.velix.imperat.annotations.base.element.ClassElement;
import dev.velix.imperat.annotations.base.element.CommandClassVisitor;
import dev.velix.imperat.annotations.base.element.MethodElement;
import dev.velix.imperat.annotations.base.element.ParameterElement;
import dev.velix.imperat.annotations.base.element.ParseElement;
import dev.velix.imperat.annotations.base.element.selector.ElementSelector;
import dev.velix.imperat.annotations.parameters.AnnotationParameterDecorator;
import dev.velix.imperat.annotations.parameters.NumericParameterDecorator;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandCoordinator;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.parameters.InputParameter;
import dev.velix.imperat.command.parameters.NumericRange;
import dev.velix.imperat.command.parameters.StrictParameterList;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.command.processors.CommandPostProcessor;
import dev.velix.imperat.command.processors.CommandPreProcessor;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.supplier.OptionalValueSupplier;
import dev.velix.imperat.util.ImperatDebugger;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.TypeWrap;
import dev.velix.imperat.util.reflection.Reflections;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class SimpleCommandClassVisitor<S extends Source>
extends CommandClassVisitor<S> {
    private final ImperatConfig<S> config;

    SimpleCommandClassVisitor(Imperat<S> imperat, AnnotationParser<S> parser, ElementSelector<MethodElement> methodSelector) {
        super(imperat, parser, methodSelector);
        this.config = imperat.config();
    }

    @Override
    public Set<dev.velix.imperat.command.Command<S>> visitCommandClass(@NotNull ClassElement clazz) {
        HashSet<dev.velix.imperat.command.Command<S>> commands = new HashSet<dev.velix.imperat.command.Command<S>>();
        Annotation commandAnnotation = this.getCommandAnnotation(clazz);
        if (clazz.isRootClass() && commandAnnotation != null && clazz.isAnnotationPresent(SubCommand.class)) {
            throw new IllegalStateException("Root command class cannot be a @SubCommand");
        }
        if (commandAnnotation != null) {
            dev.velix.imperat.command.Command<S> cmd = this.loadCommand(null, clazz, commandAnnotation);
            if (cmd != null) {
                this.loadCommandMethods(clazz);
                commands.add(cmd);
            }
        } else {
            for (ParseElement<?> element : clazz.getChildren()) {
                dev.velix.imperat.command.Command<S> cmd;
                if (!element.isAnnotationPresent(Command.class) || (cmd = this.loadCommand(null, element, Objects.requireNonNull(element.getAnnotation(Command.class)))) == null) continue;
                this.imperat.registerCommand(cmd);
            }
        }
        return commands;
    }

    private Annotation getCommandAnnotation(ClassElement clazz) {
        if (clazz.isAnnotationPresent(Command.class)) {
            return clazz.getAnnotation(Command.class);
        }
        if (clazz.isAnnotationPresent(SubCommand.class)) {
            return clazz.getAnnotation(SubCommand.class);
        }
        return null;
    }

    private void loadCommandMethods(ClassElement clazz) {
        for (ParseElement<?> element : clazz.getChildren()) {
            MethodElement method;
            if (!(element instanceof MethodElement) || !(method = (MethodElement)element).isAnnotationPresent(Command.class)) continue;
            Command cmdAnn = method.getAnnotation(Command.class);
            assert (cmdAnn != null);
            this.imperat.registerCommand(this.loadCommand(null, method, cmdAnn));
        }
    }

    private dev.velix.imperat.command.Command<S> loadCmdInstance(Annotation cmdAnnotation, ParseElement<?> element) {
        PreProcessor preProcessor = element.getAnnotation(PreProcessor.class);
        PostProcessor postProcessor = element.getAnnotation(PostProcessor.class);
        Permission permission = element.getAnnotation(Permission.class);
        Description description = element.getAnnotation(Description.class);
        if (cmdAnnotation instanceof Command) {
            Command cmdAnn = (Command)cmdAnnotation;
            String[] values = this.config.replacePlaceholders(cmdAnn.value());
            List<String> aliases = List.of(values).subList(1, values.length);
            boolean ignoreAC = cmdAnn.skipSuggestionsChecks();
            Command.Builder<S> builder = dev.velix.imperat.command.Command.create(values[0]).ignoreACPermissions(ignoreAC).aliases(aliases);
            if (permission != null) {
                builder.permission(this.config.replacePlaceholders(permission.value()));
            }
            if (description != null) {
                builder.description(this.config.replacePlaceholders(description.value()));
            }
            if (preProcessor != null) {
                builder.preProcessor(this.loadPreProcessorInstance(preProcessor.value()));
            }
            if (postProcessor != null) {
                builder.postProcessor(this.loadPostProcessorInstance(postProcessor.value()));
            }
            return builder.build();
        }
        if (cmdAnnotation instanceof SubCommand) {
            SubCommand subCommand = (SubCommand)cmdAnnotation;
            String[] values = this.config.replacePlaceholders(subCommand.value());
            assert (values != null);
            List<String> aliases = List.of(values).subList(1, values.length);
            boolean ignoreAC = subCommand.skipSuggestionsChecks();
            Command.Builder<S> builder = dev.velix.imperat.command.Command.create(values[0]).ignoreACPermissions(ignoreAC).aliases(aliases);
            if (permission != null) {
                builder.permission(this.config.replacePlaceholders(permission.value()));
            }
            if (description != null) {
                builder.description(this.config.replacePlaceholders(description.value()));
            }
            if (preProcessor != null) {
                builder.preProcessor(this.loadPreProcessorInstance(preProcessor.value()));
            }
            if (postProcessor != null) {
                builder.postProcessor(this.loadPostProcessorInstance(postProcessor.value()));
            }
            return builder.build();
        }
        return null;
    }

    private dev.velix.imperat.command.Command<S> loadCommand(@Nullable dev.velix.imperat.command.Command<S> parentCmd, ParseElement<?> parseElement, @NotNull Annotation annotation) {
        dev.velix.imperat.command.Command<S> cmd = this.loadCmdInstance(annotation, parseElement);
        if (parentCmd != null && cmd != null) {
            cmd.parent(parentCmd);
        }
        if (parseElement instanceof MethodElement) {
            MethodElement method = (MethodElement)parseElement;
            if (cmd != null) {
                if (!this.methodSelector.canBeSelected(this.imperat, this.parser, method, true)) {
                    ImperatDebugger.debug("Method '%s' has failed verification", method.getName());
                    return cmd;
                }
                if (method.getInputCount() == 0) {
                    cmd.setDefaultUsageExecution(MethodCommandExecutor.of(this.imperat, method, Collections.emptyList()));
                } else {
                    CommandUsage<S> usage = this.loadUsage(parentCmd, cmd, method);
                    if (usage != null) {
                        cmd.addUsage(usage);
                    }
                }
                return cmd;
            }
        }
        if (parseElement instanceof ClassElement) {
            ClassElement commandClass = (ClassElement)parseElement;
            for (ParseElement<?> element : commandClass.getChildren()) {
                if (element instanceof MethodElement) {
                    MethodElement method = (MethodElement)element;
                    if (cmd == null) {
                        throw new IllegalStateException("Method  '" + ((Method)method.getElement()).getName() + "' Cannot be treated as usage/subcommand, it doesn't have a parent ");
                    }
                    if (!this.methodSelector.canBeSelected(this.imperat, this.parser, method, true)) {
                        return cmd;
                    }
                    if (method.isAnnotationPresent(Usage.class)) {
                        CommandUsage<S> usage = this.loadUsage(parentCmd, cmd, method);
                        if (usage == null) continue;
                        cmd.addUsage(usage);
                        continue;
                    }
                    if (!method.isAnnotationPresent(SubCommand.class)) continue;
                    SubCommand subAnn = method.getAnnotation(SubCommand.class);
                    assert (subAnn != null);
                    dev.velix.imperat.command.Command<S> subCmd = this.loadCommand(cmd, method, subAnn);
                    assert (subCmd != null);
                    cmd.addSubCommand(subCmd, subAnn.attachDirectly());
                    continue;
                }
                if (!(element instanceof ClassElement)) continue;
                ClassElement innerClass = (ClassElement)element;
                if (innerClass.isAnnotationPresent(Command.class)) {
                    Command innerCmdAnn = innerClass.getAnnotation(Command.class);
                    assert (innerCmdAnn != null);
                    this.imperat.registerCommand(this.loadCommand(null, innerClass, innerCmdAnn));
                    return null;
                }
                if (!innerClass.isAnnotationPresent(SubCommand.class)) continue;
                if (cmd == null) {
                    throw new IllegalStateException("Inner class '" + ((Class)innerClass.getElement()).getSimpleName() + "' Cannot be  treated as subcommand, it doesn't have a parent ");
                }
                SubCommand subCommandAnn = innerClass.getAnnotation(SubCommand.class);
                assert (subCommandAnn != null);
                cmd.addSubCommand(this.loadCommand(cmd, innerClass, subCommandAnn), subCommandAnn.attachDirectly());
            }
        }
        return cmd;
    }

    private CommandPreProcessor<S> loadPreProcessorInstance(Class<? extends CommandPreProcessor<?>> clazz) {
        Constructor<?> constructor = Reflections.getConstructor(clazz, new Class[0]);
        if (constructor == null) {
            throw new UnsupportedOperationException("Couldn't find constructor in class `" + clazz.getSimpleName() + "`");
        }
        try {
            return (CommandPreProcessor)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private CommandPostProcessor<S> loadPostProcessorInstance(Class<? extends CommandPostProcessor<?>> clazz) {
        Constructor<?> constructor = Reflections.getConstructor(clazz, new Class[0]);
        if (constructor == null) {
            throw new UnsupportedOperationException("Couldn't find constructor in class `" + clazz.getSimpleName() + "`");
        }
        try {
            return (CommandPostProcessor)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private CommandUsage<S> loadUsage(@Nullable dev.velix.imperat.command.Command<S> parentCmd, @NotNull dev.velix.imperat.command.Command<S> loadedCmd, MethodElement method) {
        int inputCount = method.getInputCount();
        if (parentCmd != null) {
            int parentalParams = 0;
            if (!method.isAnnotationPresent(SubCommand.class) || !Objects.requireNonNull(method.getAnnotation(SubCommand.class)).attachDirectly()) {
                for (dev.velix.imperat.command.Command<S> parent = parentCmd; parent != null; parent = parent.parent()) {
                    parentalParams += parent.mainUsage().size();
                }
            }
            inputCount = Math.abs(method.getInputCount() - parentalParams);
        }
        ImperatDebugger.debug("The method-usage '%s', has '%s' calculated input count", method.getName(), inputCount);
        if (inputCount == 0) {
            if (parentCmd != null) {
                MethodUsageData<S> usageData = this.loadParameters(method, parentCmd);
                loadedCmd.setDefaultUsageExecution(MethodCommandExecutor.of(this.imperat, method, usageData.inheritedTotalParameters()));
            } else {
                loadedCmd.setDefaultUsageExecution(MethodCommandExecutor.of(this.imperat, method, Collections.emptyList()));
            }
            return null;
        }
        ClassElement methodOwner = (ClassElement)method.getParent();
        assert (methodOwner != null);
        MethodUsageData<S> usageData = this.loadParameters(method, parentCmd);
        MethodCommandExecutor<S> execution = MethodCommandExecutor.of(this.imperat, method, usageData.inheritedTotalParameters());
        Description description = method.getAnnotation(Description.class);
        Permission permission = methodOwner.getAnnotation(Permission.class);
        Cooldown cooldown = methodOwner.getAnnotation(Cooldown.class);
        Async async = methodOwner.getAnnotation(Async.class);
        CommandUsage.Builder builder = CommandUsage.builder().parameters(usageData.personalParameters()).execute(execution);
        if (description != null) {
            builder.description(this.config.replacePlaceholders(description.value()));
        }
        if (permission != null) {
            builder.permission(this.config.replacePlaceholders(permission.value()));
        }
        if (cooldown != null) {
            String cooldownPerm = cooldown.permission();
            builder.cooldown(cooldown.value(), cooldown.unit(), cooldownPerm.isEmpty() ? null : cooldownPerm);
        }
        if (async != null) {
            builder.coordinator(CommandCoordinator.async());
        }
        return builder.registerFlags(usageData.freeFlags).build(loadedCmd, method.isHelp());
    }

    private MethodUsageData<S> loadParameters(@NotNull MethodElement method, @Nullable dev.velix.imperat.command.Command<S> parentCmd) {
        ParameterElement parameterElement;
        LinkedList toLoad = new LinkedList();
        StrictParameterList mainUsageParameters = new StrictParameterList();
        if (method.getAnnotation(SubCommand.class) == null || !Objects.requireNonNull(method.getAnnotation(SubCommand.class)).attachDirectly()) {
            for (dev.velix.imperat.command.Command<S> currentParent = parentCmd; currentParent != null; currentParent = currentParent.parent()) {
                currentParent.mainUsage().getParameters().forEach(param -> {
                    if (!param.isFlag() || !param.asFlagParameter().flagData().isFree()) {
                        mainUsageParameters.addFirst(param);
                    }
                });
            }
        }
        LinkedList total = new LinkedList(mainUsageParameters);
        LinkedList<ParameterElement> parameterElements = new LinkedList<ParameterElement>(method.getParameters());
        HashSet freeFlags = new HashSet();
        ParameterElement senderParam = null;
        while (!parameterElements.isEmpty() && (parameterElement = parameterElements.peek()) != null) {
            Type type = ((Parameter)parameterElement.getElement()).getParameterizedType();
            if (senderParam == null && (this.imperat.canBeSender(type) || this.config.hasSourceResolver(type)) || this.config.hasContextResolver(type)) {
                senderParam = parameterElements.removeFirst();
                continue;
            }
            CommandParameter<S> commandParameter = this.loadParameter(parameterElement);
            if (commandParameter.isFlag() && commandParameter.asFlagParameter().flagData().isFree()) {
                freeFlags.add(commandParameter.asFlagParameter().flagData());
                parameterElements.removeFirst();
                continue;
            }
            CommandParameter mainParameter = (CommandParameter)mainUsageParameters.peek();
            if (mainParameter == null) {
                toLoad.add(commandParameter);
                total.add(commandParameter);
                parameterElements.removeFirst();
                continue;
            }
            if (mainParameter.similarTo(commandParameter)) {
                parameterElements.removeFirst();
                mainUsageParameters.removeFirst();
                continue;
            }
            toLoad.add(commandParameter);
            total.add(commandParameter);
            mainUsageParameters.removeFirst();
            parameterElements.removeFirst();
        }
        return new MethodUsageData(toLoad, total, freeFlags);
    }

    private <T> CommandParameter<S> loadParameter(@NotNull ParseElement<?> paramElement) {
        boolean greedy;
        ParameterElement element = (ParameterElement)paramElement;
        Parameter parameter = (Parameter)element.getElement();
        Named named = parameter.getAnnotation(Named.class);
        Flag flag = parameter.getAnnotation(Flag.class);
        Switch switchAnnotation = parameter.getAnnotation(Switch.class);
        if (flag != null && switchAnnotation != null) {
            throw new IllegalStateException("both @Flag and @Switch at the same time !");
        }
        TypeWrap parameterTypeWrap = TypeWrap.of((Class)parameter.getParameterizedType());
        ParameterType<S, ?> type = this.config.getParameterType(parameterTypeWrap.getType());
        if (type == null) {
            throw new IllegalArgumentException("Unknown type detected '" + parameterTypeWrap.getType().getTypeName() + "'");
        }
        String name = AnnotationHelper.getParamName(this.config, parameter, named, flag, switchAnnotation);
        boolean optional = flag != null || switchAnnotation != null || element.isAnnotationPresent(Optional.class) || element.isAnnotationPresent(Default.class) || element.isAnnotationPresent(DefaultProvider.class);
        Suggest suggestAnnotation = element.getAnnotation(Suggest.class);
        SuggestionProvider suggestionProvider = element.getAnnotation(SuggestionProvider.class);
        SuggestionResolver suggestionResolver = null;
        if (suggestAnnotation != null) {
            suggestionResolver = SuggestionResolver.plain(this.config.replacePlaceholders(suggestAnnotation.value()));
        } else if (suggestionProvider != null) {
            String suggestionResolverName = this.config.replacePlaceholders(suggestionProvider.value().toLowerCase());
            SuggestionResolver namedResolver = this.config.getNamedSuggestionResolver(suggestionResolverName);
            if (namedResolver != null) {
                suggestionResolver = namedResolver;
            } else {
                throw new IllegalStateException("Unregistered named suggestion resolver : " + suggestionResolverName);
            }
        }
        boolean bl = greedy = parameter.getAnnotation(Greedy.class) != null;
        if (greedy && parameter.getType() != String.class) {
            throw new IllegalArgumentException("Argument '" + parameter.getName() + "' is greedy while having a non-greedy valueType '" + parameter.getType().getName() + "'");
        }
        dev.velix.imperat.command.Description desc = dev.velix.imperat.command.Description.EMPTY;
        if (element.isAnnotationPresent(Description.class)) {
            Description descAnn = element.getAnnotation(Description.class);
            assert (descAnn != null);
            desc = dev.velix.imperat.command.Description.of(this.config.replacePlaceholders(descAnn.value()));
        }
        String permission = null;
        if (element.isAnnotationPresent(Permission.class)) {
            Permission permAnn = element.getAnnotation(Permission.class);
            assert (permAnn != null);
            permission = this.config.replacePlaceholders(permAnn.value());
        }
        OptionalValueSupplier optionalValueSupplier = OptionalValueSupplier.empty(parameterTypeWrap);
        if (optional) {
            Default defaultAnnotation = parameter.getAnnotation(Default.class);
            DefaultProvider provider = parameter.getAnnotation(DefaultProvider.class);
            try {
                optionalValueSupplier = AnnotationHelper.deduceOptionalValueSupplier(this.imperat, parameter, defaultAnnotation, provider, optionalValueSupplier);
            }
            catch (ImperatException e) {
                ImperatDebugger.error(AnnotationHelper.class, "deduceOptionalValueSupplier", e);
            }
        }
        if (flag != null) {
            String[] flagAliases = flag.value();
            if (suggestAnnotation != null) {
                suggestionResolver = SuggestionResolver.plain(this.config.replacePlaceholders(suggestAnnotation.value()));
            }
            return AnnotationParameterDecorator.decorate(CommandParameter.flag(name, type).setFree(flag.free()).suggestForInputValue(suggestionResolver).aliases(this.getAllExceptFirst(flagAliases)).flagDefaultInputValue(optionalValueSupplier).description(desc).permission(permission).build(), element);
        }
        if (switchAnnotation != null) {
            String[] switchAliases = switchAnnotation.value();
            return AnnotationParameterDecorator.decorate(CommandParameter.flagSwitch(name).setFree(switchAnnotation.free()).aliases(this.getAllExceptFirst(switchAliases)).description(desc).permission(permission).build(), element);
        }
        InputParameter param = AnnotationParameterDecorator.decorate(CommandParameter.of(name, type, permission, desc, optional, greedy, optionalValueSupplier, suggestionResolver), element);
        if (TypeUtility.isNumericType(TypeWrap.of(param.valueType())) && element.isAnnotationPresent(Range.class)) {
            Range range = element.getAnnotation(Range.class);
            assert (range != null);
            param = NumericParameterDecorator.decorate(param, NumericRange.of(range.min(), range.max()));
        }
        return param;
    }

    private List<String> getAllExceptFirst(String[] array) {
        ArrayList<String> flagAliases = new ArrayList<String>(array.length - 1);
        flagAliases.addAll(List.of(array).subList(1, array.length));
        return flagAliases;
    }

    private record MethodUsageData<S extends Source>(List<CommandParameter<S>> personalParameters, List<CommandParameter<S>> inheritedTotalParameters, Set<FlagData<S>> freeFlags) {
    }
}

