/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MethodOrderHelper {
    public static List<Method> getMethodsInSourceOrder(Class<?> clazz) throws Exception {
        String className = clazz.getName().replace('.', '/') + ".class";
        try (InputStream stream = clazz.getClassLoader().getResourceAsStream(className);){
            if (stream == null) {
                throw new IOException("Class resource not found: " + className);
            }
            ClassReader reader = new ClassReader(stream);
            MethodOrderVisitor visitor = new MethodOrderVisitor();
            reader.accept((ClassVisitor)visitor, 2);
            HashMap<CallSite, Method> methodMap = new HashMap<CallSite, Method>();
            for (Method method : clazz.getDeclaredMethods()) {
                String key = method.getName() + Type.getMethodDescriptor((Method)method);
                methodMap.put((CallSite)((Object)key), method);
            }
            ArrayList<Method> orderedMethods = new ArrayList<Method>();
            for (MethodSignature signature : visitor.getMethodSignatures()) {
                Method method;
                method = (Method)methodMap.get(signature.name + signature.descriptor);
                if (method == null || method.isSynthetic()) continue;
                orderedMethods.add(method);
            }
            ArrayList<Method> arrayList = orderedMethods;
            return arrayList;
        }
    }

    private static class MethodOrderVisitor
    extends ClassVisitor {
        private final List<MethodSignature> methodSignatures = new ArrayList<MethodSignature>();

        public MethodOrderVisitor() {
            super(589824);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            this.methodSignatures.add(new MethodSignature(name, descriptor));
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }

        public List<MethodSignature> getMethodSignatures() {
            return this.methodSignatures;
        }
    }

    private static class MethodSignature {
        final String name;
        final String descriptor;

        MethodSignature(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }
    }
}

