/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.annotations.base;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.annotations.Inherit;
import dev.velix.imperat.annotations.base.AnnotationParser;
import dev.velix.imperat.annotations.base.AnnotationReader;
import dev.velix.imperat.annotations.base.MethodOrderHelper;
import dev.velix.imperat.annotations.base.element.ClassElement;
import dev.velix.imperat.annotations.base.element.CommandClassVisitor;
import dev.velix.imperat.annotations.base.element.MethodElement;
import dev.velix.imperat.annotations.base.element.RootCommandClass;
import dev.velix.imperat.annotations.base.element.selector.ElementSelector;
import dev.velix.imperat.command.Command;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.util.ImperatDebugger;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class AnnotationReaderImpl<S extends Source>
implements AnnotationReader<S> {
    private final Imperat<S> imperat;
    private final AnnotationParser<S> parser;
    private final ElementSelector<MethodElement> methodSelector;
    private final RootCommandClass<S> rootCommandClass;
    private final ClassElement classElement;

    AnnotationReaderImpl(Imperat<S> imperat, ElementSelector<MethodElement> methodSelector, AnnotationParser<S> parser, Object instance) {
        this.imperat = imperat;
        this.parser = parser;
        this.rootCommandClass = new RootCommandClass(instance.getClass(), instance);
        this.methodSelector = methodSelector;
        this.classElement = this.read(imperat);
    }

    private ClassElement read(Imperat<S> imperat) {
        return this.readClass(imperat, this.parser, null, this.rootCommandClass.proxyClass());
    }

    private ClassElement readClass(Imperat<S> imperat, AnnotationParser<S> parser, @Nullable ClassElement parent, @NotNull Class<?> clazz) {
        List<Method> methods;
        ClassElement root = new ClassElement(parser, parent, clazz);
        try {
            methods = MethodOrderHelper.getMethodsInSourceOrder(clazz);
        }
        catch (Exception e) {
            ImperatDebugger.error(AnnotationReaderImpl.class, "readClass", e);
            throw new RuntimeException(e);
        }
        for (Method method : methods) {
            MethodElement methodElement = new MethodElement(imperat, parser, root, method);
            if (!this.methodSelector.canBeSelected(imperat, parser, methodElement, false)) continue;
            root.addChild(methodElement);
        }
        if (root.isAnnotationPresent(Inherit.class)) {
            Inherit inherit = root.getAnnotation(Inherit.class);
            assert (inherit != null);
            for (Class<?> subClass : inherit.value()) {
                root.addChild(this.readClass(imperat, parser, root, subClass));
            }
        }
        for (Class<?> child : clazz.getDeclaredClasses()) {
            root.addChild(this.readClass(imperat, parser, root, child));
        }
        return root;
    }

    @Override
    public RootCommandClass<S> getRootClass() {
        return this.rootCommandClass;
    }

    @Override
    public void accept(CommandClassVisitor<S> visitor) {
        for (Command<S> loaded : this.classElement.accept(visitor)) {
            this.imperat.registerCommand(loaded);
        }
    }
}

